@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IpFirewallRule].
 */
@PulumiTagMarker
public class IpFirewallRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IpFirewallRuleArgs = IpFirewallRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IpFirewallRuleArgsBuilder.() -> Unit) {
        val builder = IpFirewallRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IpFirewallRule {
        val builtJavaResource = com.pulumi.azurenative.synapse.IpFirewallRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IpFirewallRule(builtJavaResource)
    }
}

/**
 * IP firewall rule
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create an IP firewall rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipFirewallRule = new AzureNative.Synapse.IpFirewallRule("ipFirewallRule", new()
 *     {
 *         EndIpAddress = "10.0.0.254",
 *         ResourceGroupName = "ExampleResourceGroup",
 *         RuleName = "ExampleIpFirewallRule",
 *         StartIpAddress = "10.0.0.0",
 *         WorkspaceName = "ExampleWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewIpFirewallRule(ctx, "ipFirewallRule", &synapse.IpFirewallRuleArgs{
 * 			EndIpAddress:      pulumi.String("10.0.0.254"),
 * 			ResourceGroupName: pulumi.String("ExampleResourceGroup"),
 * 			RuleName:          pulumi.String("ExampleIpFirewallRule"),
 * 			StartIpAddress:    pulumi.String("10.0.0.0"),
 * 			WorkspaceName:     pulumi.String("ExampleWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.IpFirewallRule;
 * import com.pulumi.azurenative.synapse.IpFirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipFirewallRule = new IpFirewallRule("ipFirewallRule", IpFirewallRuleArgs.builder()
 *             .endIpAddress("10.0.0.254")
 *             .resourceGroupName("ExampleResourceGroup")
 *             .ruleName("ExampleIpFirewallRule")
 *             .startIpAddress("10.0.0.0")
 *             .workspaceName("ExampleWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:IpFirewallRule ExampleIpFirewallRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/firewallRules/{ruleName}
 * ```
 */
public class IpFirewallRule internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.IpFirewallRule,
) : KotlinCustomResource(javaResource, IpFirewallRuleMapper) {
    /**
     * The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress
     */
    public val endIpAddress: Output<String>?
        get() = javaResource.endIpAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The start IP address of the firewall rule. Must be IPv4 format
     */
    public val startIpAddress: Output<String>?
        get() = javaResource.startIpAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IpFirewallRuleMapper : ResourceMapper<IpFirewallRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.IpFirewallRule::class == javaResource::class

    override fun map(javaResource: Resource): IpFirewallRule = IpFirewallRule(
        javaResource as
            com.pulumi.azurenative.synapse.IpFirewallRule,
    )
}

/**
 * @see [IpFirewallRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IpFirewallRule].
 */
public suspend fun ipFirewallRule(
    name: String,
    block: suspend IpFirewallRuleResourceBuilder.() -> Unit,
): IpFirewallRule {
    val builder = IpFirewallRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IpFirewallRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipFirewallRule(name: String): IpFirewallRule {
    val builder = IpFirewallRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
