@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.IpFirewallRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IP firewall rule
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create an IP firewall rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipFirewallRule = new AzureNative.Synapse.IpFirewallRule("ipFirewallRule", new()
 *     {
 *         EndIpAddress = "10.0.0.254",
 *         ResourceGroupName = "ExampleResourceGroup",
 *         RuleName = "ExampleIpFirewallRule",
 *         StartIpAddress = "10.0.0.0",
 *         WorkspaceName = "ExampleWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewIpFirewallRule(ctx, "ipFirewallRule", &synapse.IpFirewallRuleArgs{
 * 			EndIpAddress:      pulumi.String("10.0.0.254"),
 * 			ResourceGroupName: pulumi.String("ExampleResourceGroup"),
 * 			RuleName:          pulumi.String("ExampleIpFirewallRule"),
 * 			StartIpAddress:    pulumi.String("10.0.0.0"),
 * 			WorkspaceName:     pulumi.String("ExampleWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.IpFirewallRule;
 * import com.pulumi.azurenative.synapse.IpFirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipFirewallRule = new IpFirewallRule("ipFirewallRule", IpFirewallRuleArgs.builder()
 *             .endIpAddress("10.0.0.254")
 *             .resourceGroupName("ExampleResourceGroup")
 *             .ruleName("ExampleIpFirewallRule")
 *             .startIpAddress("10.0.0.0")
 *             .workspaceName("ExampleWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:IpFirewallRule ExampleIpFirewallRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/firewallRules/{ruleName}
 * ```
 * @property endIpAddress The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleName The IP firewall rule name
 * @property startIpAddress The start IP address of the firewall rule. Must be IPv4 format
 * @property workspaceName The name of the workspace.
 */
public data class IpFirewallRuleArgs(
    public val endIpAddress: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val startIpAddress: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.IpFirewallRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.IpFirewallRuleArgs =
        com.pulumi.azurenative.synapse.IpFirewallRuleArgs.builder()
            .endIpAddress(endIpAddress?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .startIpAddress(startIpAddress?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpFirewallRuleArgs].
 */
@PulumiTagMarker
public class IpFirewallRuleArgsBuilder internal constructor() {
    private var endIpAddress: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var startIpAddress: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress
     */
    @JvmName("itwmifshnabqntfi")
    public suspend fun endIpAddress(`value`: Output<String>) {
        this.endIpAddress = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tufmiuwkjvvyorwe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The IP firewall rule name
     */
    @JvmName("rplcygbstybkpfud")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The start IP address of the firewall rule. Must be IPv4 format
     */
    @JvmName("wxhmdvpmutfxjstp")
    public suspend fun startIpAddress(`value`: Output<String>) {
        this.startIpAddress = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("savtfaxjxstrmppa")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress
     */
    @JvmName("qfbygjsfobmtsehb")
    public suspend fun endIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endIpAddress = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tpucqrnllelwjtfw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The IP firewall rule name
     */
    @JvmName("xrveukjoshiyfncl")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value The start IP address of the firewall rule. Must be IPv4 format
     */
    @JvmName("ywyligwyhjxsqijj")
    public suspend fun startIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startIpAddress = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("moxojkycxcwksnlw")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): IpFirewallRuleArgs = IpFirewallRuleArgs(
        endIpAddress = endIpAddress,
        resourceGroupName = resourceGroupName,
        ruleName = ruleName,
        startIpAddress = startIpAddress,
        workspaceName = workspaceName,
    )
}
