@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.KeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A workspace key
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or update a workspace key
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var key = new AzureNative.Synapse.Key("key", new()
 *     {
 *         IsActiveCMK = true,
 *         KeyName = "somekey",
 *         KeyVaultUrl = "https://vault.azure.net/keys/somesecret",
 *         ResourceGroupName = "ExampleResourceGroup",
 *         WorkspaceName = "ExampleWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewKey(ctx, "key", &synapse.KeyArgs{
 * 			IsActiveCMK:       pulumi.Bool(true),
 * 			KeyName:           pulumi.String("somekey"),
 * 			KeyVaultUrl:       pulumi.String("https://vault.azure.net/keys/somesecret"),
 * 			ResourceGroupName: pulumi.String("ExampleResourceGroup"),
 * 			WorkspaceName:     pulumi.String("ExampleWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.Key;
 * import com.pulumi.azurenative.synapse.KeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var key = new Key("key", KeyArgs.builder()
 *             .isActiveCMK(true)
 *             .keyName("somekey")
 *             .keyVaultUrl("https://vault.azure.net/keys/somesecret")
 *             .resourceGroupName("ExampleResourceGroup")
 *             .workspaceName("ExampleWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:Key somekey /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/keys/{keyName}
 * ```
 * @property isActiveCMK Used to activate the workspace after a customer managed key is provided.
 * @property keyName The name of the workspace key
 * @property keyVaultUrl The Key Vault Url of the workspace key.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class KeyArgs(
    public val isActiveCMK: Output<Boolean>? = null,
    public val keyName: Output<String>? = null,
    public val keyVaultUrl: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.KeyArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.KeyArgs =
        com.pulumi.azurenative.synapse.KeyArgs.builder()
            .isActiveCMK(isActiveCMK?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyVaultUrl(keyVaultUrl?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyArgs].
 */
@PulumiTagMarker
public class KeyArgsBuilder internal constructor() {
    private var isActiveCMK: Output<Boolean>? = null

    private var keyName: Output<String>? = null

    private var keyVaultUrl: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Used to activate the workspace after a customer managed key is provided.
     */
    @JvmName("ekklkwphtilovrtj")
    public suspend fun isActiveCMK(`value`: Output<Boolean>) {
        this.isActiveCMK = value
    }

    /**
     * @param value The name of the workspace key
     */
    @JvmName("jepkfntgkikegfwg")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The Key Vault Url of the workspace key.
     */
    @JvmName("ysytcnaxcikilhrh")
    public suspend fun keyVaultUrl(`value`: Output<String>) {
        this.keyVaultUrl = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nreghqhsxoefayet")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("flyxtqwknplgcxwv")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Used to activate the workspace after a customer managed key is provided.
     */
    @JvmName("trcxnwnlrcautshn")
    public suspend fun isActiveCMK(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isActiveCMK = mapped
    }

    /**
     * @param value The name of the workspace key
     */
    @JvmName("tutoyvyrhtakqvdg")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The Key Vault Url of the workspace key.
     */
    @JvmName("fgfmtxxfsfprcsjw")
    public suspend fun keyVaultUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUrl = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hfholypmkfmtmoum")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("kfuysgqfuummhyfm")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): KeyArgs = KeyArgs(
        isActiveCMK = isActiveCMK,
        keyName = keyName,
        keyVaultUrl = keyVaultUrl,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
