@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.TableLevelSharingPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.TableLevelSharingPropertiesResponse.Companion.toKotlin as tableLevelSharingPropertiesResponseToKotlin

/**
 * Builder for [KustoPoolAttachedDatabaseConfiguration].
 */
@PulumiTagMarker
public class KustoPoolAttachedDatabaseConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KustoPoolAttachedDatabaseConfigurationArgs =
        KustoPoolAttachedDatabaseConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend KustoPoolAttachedDatabaseConfigurationArgsBuilder.() -> Unit) {
        val builder = KustoPoolAttachedDatabaseConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KustoPoolAttachedDatabaseConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.KustoPoolAttachedDatabaseConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return KustoPoolAttachedDatabaseConfiguration(builtJavaResource)
    }
}

/**
 * Class representing an attached database configuration.
 * Azure REST API version: 2021-06-01-preview. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * ## Example Usage
 * ### KustoPoolAttachedDatabaseConfigurationsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoPoolAttachedDatabaseConfiguration = new AzureNative.Synapse.KustoPoolAttachedDatabaseConfiguration("kustoPoolAttachedDatabaseConfiguration", new()
 *     {
 *         AttachedDatabaseConfigurationName = "attachedDatabaseConfigurations1",
 *         DatabaseName = "kustodatabase",
 *         DefaultPrincipalsModificationKind = "Union",
 *         KustoPoolName = "kustoclusterrptest4",
 *         KustoPoolResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/Workspaces/kustorptest/KustoPools/kustoclusterrptest4",
 *         Location = "westus",
 *         ResourceGroupName = "kustorptest",
 *         TableLevelSharingProperties = new AzureNative.Synapse.Inputs.TableLevelSharingPropertiesArgs
 *         {
 *             ExternalTablesToExclude = new[]
 *             {
 *                 "ExternalTable2",
 *             },
 *             ExternalTablesToInclude = new[]
 *             {
 *                 "ExternalTable1",
 *             },
 *             MaterializedViewsToExclude = new[]
 *             {
 *                 "MaterializedViewTable2",
 *             },
 *             MaterializedViewsToInclude = new[]
 *             {
 *                 "MaterializedViewTable1",
 *             },
 *             TablesToExclude = new[]
 *             {
 *                 "Table2",
 *             },
 *             TablesToInclude = new[]
 *             {
 *                 "Table1",
 *             },
 *         },
 *         WorkspaceName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewKustoPoolAttachedDatabaseConfiguration(ctx, "kustoPoolAttachedDatabaseConfiguration", &synapse.KustoPoolAttachedDatabaseConfigurationArgs{
 * 			AttachedDatabaseConfigurationName: pulumi.String("attachedDatabaseConfigurations1"),
 * 			DatabaseName:                      pulumi.String("kustodatabase"),
 * 			DefaultPrincipalsModificationKind: pulumi.String("Union"),
 * 			KustoPoolName:                     pulumi.String("kustoclusterrptest4"),
 * 			KustoPoolResourceId:               pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/Workspaces/kustorptest/KustoPools/kustoclusterrptest4"),
 * 			Location:                          pulumi.String("westus"),
 * 			ResourceGroupName:                 pulumi.String("kustorptest"),
 * 			TableLevelSharingProperties: &synapse.TableLevelSharingPropertiesArgs{
 * 				ExternalTablesToExclude: pulumi.StringArray{
 * 					pulumi.String("ExternalTable2"),
 * 				},
 * 				ExternalTablesToInclude: pulumi.StringArray{
 * 					pulumi.String("ExternalTable1"),
 * 				},
 * 				MaterializedViewsToExclude: pulumi.StringArray{
 * 					pulumi.String("MaterializedViewTable2"),
 * 				},
 * 				MaterializedViewsToInclude: pulumi.StringArray{
 * 					pulumi.String("MaterializedViewTable1"),
 * 				},
 * 				TablesToExclude: pulumi.StringArray{
 * 					pulumi.String("Table2"),
 * 				},
 * 				TablesToInclude: pulumi.StringArray{
 * 					pulumi.String("Table1"),
 * 				},
 * 			},
 * 			WorkspaceName: pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.KustoPoolAttachedDatabaseConfiguration;
 * import com.pulumi.azurenative.synapse.KustoPoolAttachedDatabaseConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoPoolAttachedDatabaseConfiguration = new KustoPoolAttachedDatabaseConfiguration("kustoPoolAttachedDatabaseConfiguration", KustoPoolAttachedDatabaseConfigurationArgs.builder()
 *             .attachedDatabaseConfigurationName("attachedDatabaseConfigurations1")
 *             .databaseName("kustodatabase")
 *             .defaultPrincipalsModificationKind("Union")
 *             .kustoPoolName("kustoclusterrptest4")
 *             .kustoPoolResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/Workspaces/kustorptest/KustoPools/kustoclusterrptest4")
 *             .location("westus")
 *             .resourceGroupName("kustorptest")
 *             .tableLevelSharingProperties(Map.ofEntries(
 *                 Map.entry("externalTablesToExclude", "ExternalTable2"),
 *                 Map.entry("externalTablesToInclude", "ExternalTable1"),
 *                 Map.entry("materializedViewsToExclude", "MaterializedViewTable2"),
 *                 Map.entry("materializedViewsToInclude", "MaterializedViewTable1"),
 *                 Map.entry("tablesToExclude", "Table2"),
 *                 Map.entry("tablesToInclude", "Table1")
 *             ))
 *             .workspaceName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:KustoPoolAttachedDatabaseConfiguration KustoClusterRPTest4/attachedDatabaseConfigurations1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/attachedDatabaseConfigurations/{attachedDatabaseConfigurationName}
 * ```
 */
public class KustoPoolAttachedDatabaseConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.KustoPoolAttachedDatabaseConfiguration,
) : KotlinCustomResource(javaResource, KustoPoolAttachedDatabaseConfigurationMapper) {
    /**
     * The list of databases from the clusterResourceId which are currently attached to the kusto pool.
     */
    public val attachedDatabaseNames: Output<List<String>>
        get() = javaResource.attachedDatabaseNames().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the database which you would like to attach, use * if you want to follow all current and future databases.
     */
    public val databaseName: Output<String>
        get() = javaResource.databaseName().applyValue({ args0 -> args0 })

    /**
     * The default principals modification kind
     */
    public val defaultPrincipalsModificationKind: Output<String>
        get() = javaResource.defaultPrincipalsModificationKind().applyValue({ args0 -> args0 })

    /**
     * The resource id of the kusto pool where the databases you would like to attach reside.
     */
    public val kustoPoolResourceId: Output<String>
        get() = javaResource.kustoPoolResourceId().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Table level sharing specifications
     */
    public val tableLevelSharingProperties: Output<TableLevelSharingPropertiesResponse>?
        get() = javaResource.tableLevelSharingProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> tableLevelSharingPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object KustoPoolAttachedDatabaseConfigurationMapper :
    ResourceMapper<KustoPoolAttachedDatabaseConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.KustoPoolAttachedDatabaseConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): KustoPoolAttachedDatabaseConfiguration =
        KustoPoolAttachedDatabaseConfiguration(
            javaResource as
                com.pulumi.azurenative.synapse.KustoPoolAttachedDatabaseConfiguration,
        )
}

/**
 * @see [KustoPoolAttachedDatabaseConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KustoPoolAttachedDatabaseConfiguration].
 */
public suspend fun kustoPoolAttachedDatabaseConfiguration(
    name: String,
    block: suspend KustoPoolAttachedDatabaseConfigurationResourceBuilder.() -> Unit,
):
    KustoPoolAttachedDatabaseConfiguration {
    val builder = KustoPoolAttachedDatabaseConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KustoPoolAttachedDatabaseConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kustoPoolAttachedDatabaseConfiguration(name: String):
    KustoPoolAttachedDatabaseConfiguration {
    val builder = KustoPoolAttachedDatabaseConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
