@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.DatabaseStatisticsResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.synapse.kotlin.outputs.DatabaseStatisticsResponse.Companion.toKotlin as databaseStatisticsResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ReadOnlyFollowingDatabase].
 */
@PulumiTagMarker
public class ReadOnlyFollowingDatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReadOnlyFollowingDatabaseArgs = ReadOnlyFollowingDatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReadOnlyFollowingDatabaseArgsBuilder.() -> Unit) {
        val builder = ReadOnlyFollowingDatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReadOnlyFollowingDatabase {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.ReadOnlyFollowingDatabase(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReadOnlyFollowingDatabase(builtJavaResource)
    }
}

/**
 * Class representing a read only following database.
 * Azure REST API version: 2021-06-01-preview.
 * ## Example Usage
 * ### KustoPoolDatabasesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var readOnlyFollowingDatabase = new AzureNative.Synapse.ReadOnlyFollowingDatabase("readOnlyFollowingDatabase", new()
 *     {
 *         DatabaseName = "KustoDatabase8",
 *         KustoPoolName = "kustoclusterrptest4",
 *         ResourceGroupName = "kustorptest",
 *         WorkspaceName = "synapseWorkspaceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewReadOnlyFollowingDatabase(ctx, "readOnlyFollowingDatabase", &synapse.ReadOnlyFollowingDatabaseArgs{
 * 			DatabaseName:      pulumi.String("KustoDatabase8"),
 * 			KustoPoolName:     pulumi.String("kustoclusterrptest4"),
 * 			ResourceGroupName: pulumi.String("kustorptest"),
 * 			WorkspaceName:     pulumi.String("synapseWorkspaceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.ReadOnlyFollowingDatabase;
 * import com.pulumi.azurenative.synapse.ReadOnlyFollowingDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var readOnlyFollowingDatabase = new ReadOnlyFollowingDatabase("readOnlyFollowingDatabase", ReadOnlyFollowingDatabaseArgs.builder()
 *             .databaseName("KustoDatabase8")
 *             .kustoPoolName("kustoclusterrptest4")
 *             .resourceGroupName("kustorptest")
 *             .workspaceName("synapseWorkspaceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:ReadOnlyFollowingDatabase KustoClusterRPTest4/KustoDatabase8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/databases/{databaseName}
 * ```
 */
public class ReadOnlyFollowingDatabase internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.ReadOnlyFollowingDatabase,
) : KotlinCustomResource(javaResource, ReadOnlyFollowingDatabaseMapper) {
    /**
     * The name of the attached database configuration cluster
     */
    public val attachedDatabaseConfigurationName: Output<String>
        get() = javaResource.attachedDatabaseConfigurationName().applyValue({ args0 -> args0 })

    /**
     * The time the data should be kept in cache for fast queries in TimeSpan.
     */
    public val hotCachePeriod: Output<String>?
        get() = javaResource.hotCachePeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of the database
     * Expected value is 'ReadOnlyFollowing'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The name of the leader cluster
     */
    public val leaderClusterResourceId: Output<String>
        get() = javaResource.leaderClusterResourceId().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The principals modification kind of the database
     */
    public val principalsModificationKind: Output<String>
        get() = javaResource.principalsModificationKind().applyValue({ args0 -> args0 })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The time the data should be kept before it stops being accessible to queries in TimeSpan.
     */
    public val softDeletePeriod: Output<String>
        get() = javaResource.softDeletePeriod().applyValue({ args0 -> args0 })

    /**
     * The statistics of the database.
     */
    public val statistics: Output<DatabaseStatisticsResponse>
        get() = javaResource.statistics().applyValue({ args0 ->
            args0.let({ args0 ->
                databaseStatisticsResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReadOnlyFollowingDatabaseMapper : ResourceMapper<ReadOnlyFollowingDatabase> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.ReadOnlyFollowingDatabase::class == javaResource::class

    override fun map(javaResource: Resource): ReadOnlyFollowingDatabase =
        ReadOnlyFollowingDatabase(
            javaResource as
                com.pulumi.azurenative.synapse.ReadOnlyFollowingDatabase,
        )
}

/**
 * @see [ReadOnlyFollowingDatabase].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReadOnlyFollowingDatabase].
 */
public suspend fun readOnlyFollowingDatabase(
    name: String,
    block: suspend ReadOnlyFollowingDatabaseResourceBuilder.() -> Unit,
): ReadOnlyFollowingDatabase {
    val builder = ReadOnlyFollowingDatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReadOnlyFollowingDatabase].
 * @param name The _unique_ name of the resulting resource.
 */
public fun readOnlyFollowingDatabase(name: String): ReadOnlyFollowingDatabase {
    val builder = ReadOnlyFollowingDatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
