@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.ReadOnlyFollowingDatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing a read only following database.
 * Azure REST API version: 2021-06-01-preview.
 * ## Example Usage
 * ### KustoPoolDatabasesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var readOnlyFollowingDatabase = new AzureNative.Synapse.ReadOnlyFollowingDatabase("readOnlyFollowingDatabase", new()
 *     {
 *         DatabaseName = "KustoDatabase8",
 *         KustoPoolName = "kustoclusterrptest4",
 *         ResourceGroupName = "kustorptest",
 *         WorkspaceName = "synapseWorkspaceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewReadOnlyFollowingDatabase(ctx, "readOnlyFollowingDatabase", &synapse.ReadOnlyFollowingDatabaseArgs{
 * 			DatabaseName:      pulumi.String("KustoDatabase8"),
 * 			KustoPoolName:     pulumi.String("kustoclusterrptest4"),
 * 			ResourceGroupName: pulumi.String("kustorptest"),
 * 			WorkspaceName:     pulumi.String("synapseWorkspaceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.ReadOnlyFollowingDatabase;
 * import com.pulumi.azurenative.synapse.ReadOnlyFollowingDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var readOnlyFollowingDatabase = new ReadOnlyFollowingDatabase("readOnlyFollowingDatabase", ReadOnlyFollowingDatabaseArgs.builder()
 *             .databaseName("KustoDatabase8")
 *             .kustoPoolName("kustoclusterrptest4")
 *             .resourceGroupName("kustorptest")
 *             .workspaceName("synapseWorkspaceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:ReadOnlyFollowingDatabase KustoClusterRPTest4/KustoDatabase8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/databases/{databaseName}
 * ```
 * @property databaseName The name of the database in the Kusto pool.
 * @property hotCachePeriod The time the data should be kept in cache for fast queries in TimeSpan.
 * @property kind Kind of the database
 * Expected value is 'ReadOnlyFollowing'.
 * @property kustoPoolName The name of the Kusto pool.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class ReadOnlyFollowingDatabaseArgs(
    public val databaseName: Output<String>? = null,
    public val hotCachePeriod: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val kustoPoolName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.ReadOnlyFollowingDatabaseArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.ReadOnlyFollowingDatabaseArgs =
        com.pulumi.azurenative.synapse.ReadOnlyFollowingDatabaseArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .hotCachePeriod(hotCachePeriod?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .kustoPoolName(kustoPoolName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReadOnlyFollowingDatabaseArgs].
 */
@PulumiTagMarker
public class ReadOnlyFollowingDatabaseArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var hotCachePeriod: Output<String>? = null

    private var kind: Output<String>? = null

    private var kustoPoolName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("nnxxuecxvawmcscq")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The time the data should be kept in cache for fast queries in TimeSpan.
     */
    @JvmName("pmwhjqpqsyyifoci")
    public suspend fun hotCachePeriod(`value`: Output<String>) {
        this.hotCachePeriod = value
    }

    /**
     * @param value Kind of the database
     * Expected value is 'ReadOnlyFollowing'.
     */
    @JvmName("opunkunartffrtje")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("tnskrherdluymbht")
    public suspend fun kustoPoolName(`value`: Output<String>) {
        this.kustoPoolName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("fwbaxehiqpofdwfw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cucaptojnyatlbjg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ldeturjiririomkl")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("deufhnesxljxypvw")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The time the data should be kept in cache for fast queries in TimeSpan.
     */
    @JvmName("mqdjrhvbxvlrhkoq")
    public suspend fun hotCachePeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hotCachePeriod = mapped
    }

    /**
     * @param value Kind of the database
     * Expected value is 'ReadOnlyFollowing'.
     */
    @JvmName("kipgaayqttjhlwse")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("woxmlmgdxisjhcpe")
    public suspend fun kustoPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoPoolName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("chvprhurfcilhudk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("voyhjmvvgktvmpgk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("dghyameelmjmxhuw")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ReadOnlyFollowingDatabaseArgs = ReadOnlyFollowingDatabaseArgs(
        databaseName = databaseName,
        hotCachePeriod = hotCachePeriod,
        kind = kind,
        kustoPoolName = kustoPoolName,
        location = location,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
