@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SqlPoolTransparentDataEncryption].
 */
@PulumiTagMarker
public class SqlPoolTransparentDataEncryptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlPoolTransparentDataEncryptionArgs = SqlPoolTransparentDataEncryptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlPoolTransparentDataEncryptionArgsBuilder.() -> Unit) {
        val builder = SqlPoolTransparentDataEncryptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlPoolTransparentDataEncryption {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.SqlPoolTransparentDataEncryption(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlPoolTransparentDataEncryption(builtJavaResource)
    }
}

/**
 * Represents a Sql pool transparent data encryption configuration.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or update a Sql pool's transparent data encryption configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolTransparentDataEncryption = new AzureNative.Synapse.SqlPoolTransparentDataEncryption("sqlPoolTransparentDataEncryption", new()
 *     {
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         SqlPoolName = "sqlcrudtest-9187",
 *         Status = "Enabled",
 *         TransparentDataEncryptionName = "current",
 *         WorkspaceName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolTransparentDataEncryption(ctx, "sqlPoolTransparentDataEncryption", &synapse.SqlPoolTransparentDataEncryptionArgs{
 * 			ResourceGroupName:             pulumi.String("sqlcrudtest-6852"),
 * 			SqlPoolName:                   pulumi.String("sqlcrudtest-9187"),
 * 			Status:                        pulumi.String("Enabled"),
 * 			TransparentDataEncryptionName: pulumi.String("current"),
 * 			WorkspaceName:                 pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolTransparentDataEncryption;
 * import com.pulumi.azurenative.synapse.SqlPoolTransparentDataEncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolTransparentDataEncryption = new SqlPoolTransparentDataEncryption("sqlPoolTransparentDataEncryption", SqlPoolTransparentDataEncryptionArgs.builder()
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .sqlPoolName("sqlcrudtest-9187")
 *             .status("Enabled")
 *             .transparentDataEncryptionName("current")
 *             .workspaceName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPoolTransparentDataEncryption current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/transparentDataEncryption/{transparentDataEncryptionName}
 * ```
 */
public class SqlPoolTransparentDataEncryption internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.SqlPoolTransparentDataEncryption,
) : KotlinCustomResource(javaResource, SqlPoolTransparentDataEncryptionMapper) {
    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the database transparent data encryption.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlPoolTransparentDataEncryptionMapper :
    ResourceMapper<SqlPoolTransparentDataEncryption> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.SqlPoolTransparentDataEncryption::class == javaResource::class

    override fun map(javaResource: Resource): SqlPoolTransparentDataEncryption =
        SqlPoolTransparentDataEncryption(
            javaResource as
                com.pulumi.azurenative.synapse.SqlPoolTransparentDataEncryption,
        )
}

/**
 * @see [SqlPoolTransparentDataEncryption].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlPoolTransparentDataEncryption].
 */
public suspend fun sqlPoolTransparentDataEncryption(
    name: String,
    block: suspend SqlPoolTransparentDataEncryptionResourceBuilder.() -> Unit,
):
    SqlPoolTransparentDataEncryption {
    val builder = SqlPoolTransparentDataEncryptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlPoolTransparentDataEncryption].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlPoolTransparentDataEncryption(name: String): SqlPoolTransparentDataEncryption {
    val builder = SqlPoolTransparentDataEncryptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
