@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SqlPoolVulnerabilityAssessmentRuleBaseline].
 */
@PulumiTagMarker
public class SqlPoolVulnerabilityAssessmentRuleBaselineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlPoolVulnerabilityAssessmentRuleBaselineArgs =
        SqlPoolVulnerabilityAssessmentRuleBaselineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend SqlPoolVulnerabilityAssessmentRuleBaselineArgsBuilder.() -> Unit) {
        val builder = SqlPoolVulnerabilityAssessmentRuleBaselineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlPoolVulnerabilityAssessmentRuleBaseline {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentRuleBaseline(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlPoolVulnerabilityAssessmentRuleBaseline(builtJavaResource)
    }
}

/**
 * A Sql pool vulnerability assessment rule baseline.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Creates or updates a database's vulnerability assessment rule baseline.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolVulnerabilityAssessmentRuleBaseline = new AzureNative.Synapse.SqlPoolVulnerabilityAssessmentRuleBaseline("sqlPoolVulnerabilityAssessmentRuleBaseline", new()
 *     {
 *         BaselineName = "default",
 *         BaselineResults = new[]
 *         {
 *             new AzureNative.Synapse.Inputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs
 *             {
 *                 Result = new[]
 *                 {
 *                     "userA",
 *                     "SELECT",
 *                 },
 *             },
 *             new AzureNative.Synapse.Inputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs
 *             {
 *                 Result = new[]
 *                 {
 *                     "userB",
 *                     "SELECT",
 *                 },
 *             },
 *             new AzureNative.Synapse.Inputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs
 *             {
 *                 Result = new[]
 *                 {
 *                     "userC",
 *                     "SELECT",
 *                     "tableId_4",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         RuleId = "VA1001",
 *         SqlPoolName = "testdb",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "vulnerabilityaseessmenttest-6440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolVulnerabilityAssessmentRuleBaseline(ctx, "sqlPoolVulnerabilityAssessmentRuleBaseline", &synapse.SqlPoolVulnerabilityAssessmentRuleBaselineArgs{
 * 			BaselineName: pulumi.String("default"),
 * 			BaselineResults: []synapse.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs{
 * 				{
 * 					Result: pulumi.StringArray{
 * 						pulumi.String("userA"),
 * 						pulumi.String("SELECT"),
 * 					},
 * 				},
 * 				{
 * 					Result: pulumi.StringArray{
 * 						pulumi.String("userB"),
 * 						pulumi.String("SELECT"),
 * 					},
 * 				},
 * 				{
 * 					Result: pulumi.StringArray{
 * 						pulumi.String("userC"),
 * 						pulumi.String("SELECT"),
 * 						pulumi.String("tableId_4"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			RuleId:                      pulumi.String("VA1001"),
 * 			SqlPoolName:                 pulumi.String("testdb"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentRuleBaseline;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentRuleBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolVulnerabilityAssessmentRuleBaseline = new SqlPoolVulnerabilityAssessmentRuleBaseline("sqlPoolVulnerabilityAssessmentRuleBaseline", SqlPoolVulnerabilityAssessmentRuleBaselineArgs.builder()
 *             .baselineName("default")
 *             .baselineResults(
 *                 Map.of("result",
 *                     "userA",
 *                     "SELECT"),
 *                 Map.of("result",
 *                     "userB",
 *                     "SELECT"),
 *                 Map.of("result",
 *                     "userC",
 *                     "SELECT",
 *                     "tableId_4"))
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .ruleId("VA1001")
 *             .sqlPoolName("testdb")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("vulnerabilityaseessmenttest-6440")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPoolVulnerabilityAssessmentRuleBaseline default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}
 * ```
 */
public class SqlPoolVulnerabilityAssessmentRuleBaseline internal constructor(
    override val javaResource:
    com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentRuleBaseline,
) : KotlinCustomResource(javaResource, SqlPoolVulnerabilityAssessmentRuleBaselineMapper) {
    /**
     * The rule baseline result
     */
    public val baselineResults: Output<List<SqlPoolVulnerabilityAssessmentRuleBaselineItemResponse>>
        get() = javaResource.baselineResults().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlPoolVulnerabilityAssessmentRuleBaselineMapper :
    ResourceMapper<SqlPoolVulnerabilityAssessmentRuleBaseline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentRuleBaseline::class == javaResource::class

    override fun map(javaResource: Resource): SqlPoolVulnerabilityAssessmentRuleBaseline =
        SqlPoolVulnerabilityAssessmentRuleBaseline(
            javaResource as
                com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentRuleBaseline,
        )
}

/**
 * @see [SqlPoolVulnerabilityAssessmentRuleBaseline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlPoolVulnerabilityAssessmentRuleBaseline].
 */
public suspend fun sqlPoolVulnerabilityAssessmentRuleBaseline(
    name: String,
    block: suspend SqlPoolVulnerabilityAssessmentRuleBaselineResourceBuilder.() -> Unit,
):
    SqlPoolVulnerabilityAssessmentRuleBaseline {
    val builder = SqlPoolVulnerabilityAssessmentRuleBaselineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlPoolVulnerabilityAssessmentRuleBaseline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlPoolVulnerabilityAssessmentRuleBaseline(name: String):
    SqlPoolVulnerabilityAssessmentRuleBaseline {
    val builder = SqlPoolVulnerabilityAssessmentRuleBaselineResourceBuilder()
    builder.name(name)
    return builder.build()
}
