@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentRuleBaselineArgs.builder
import com.pulumi.azurenative.synapse.kotlin.inputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A Sql pool vulnerability assessment rule baseline.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Creates or updates a database's vulnerability assessment rule baseline.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolVulnerabilityAssessmentRuleBaseline = new AzureNative.Synapse.SqlPoolVulnerabilityAssessmentRuleBaseline("sqlPoolVulnerabilityAssessmentRuleBaseline", new()
 *     {
 *         BaselineName = "default",
 *         BaselineResults = new[]
 *         {
 *             new AzureNative.Synapse.Inputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs
 *             {
 *                 Result = new[]
 *                 {
 *                     "userA",
 *                     "SELECT",
 *                 },
 *             },
 *             new AzureNative.Synapse.Inputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs
 *             {
 *                 Result = new[]
 *                 {
 *                     "userB",
 *                     "SELECT",
 *                 },
 *             },
 *             new AzureNative.Synapse.Inputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs
 *             {
 *                 Result = new[]
 *                 {
 *                     "userC",
 *                     "SELECT",
 *                     "tableId_4",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         RuleId = "VA1001",
 *         SqlPoolName = "testdb",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "vulnerabilityaseessmenttest-6440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolVulnerabilityAssessmentRuleBaseline(ctx, "sqlPoolVulnerabilityAssessmentRuleBaseline", &synapse.SqlPoolVulnerabilityAssessmentRuleBaselineArgs{
 * 			BaselineName: pulumi.String("default"),
 * 			BaselineResults: []synapse.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs{
 * 				{
 * 					Result: pulumi.StringArray{
 * 						pulumi.String("userA"),
 * 						pulumi.String("SELECT"),
 * 					},
 * 				},
 * 				{
 * 					Result: pulumi.StringArray{
 * 						pulumi.String("userB"),
 * 						pulumi.String("SELECT"),
 * 					},
 * 				},
 * 				{
 * 					Result: pulumi.StringArray{
 * 						pulumi.String("userC"),
 * 						pulumi.String("SELECT"),
 * 						pulumi.String("tableId_4"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			RuleId:                      pulumi.String("VA1001"),
 * 			SqlPoolName:                 pulumi.String("testdb"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentRuleBaseline;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentRuleBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolVulnerabilityAssessmentRuleBaseline = new SqlPoolVulnerabilityAssessmentRuleBaseline("sqlPoolVulnerabilityAssessmentRuleBaseline", SqlPoolVulnerabilityAssessmentRuleBaselineArgs.builder()
 *             .baselineName("default")
 *             .baselineResults(
 *                 Map.of("result",
 *                     "userA",
 *                     "SELECT"),
 *                 Map.of("result",
 *                     "userB",
 *                     "SELECT"),
 *                 Map.of("result",
 *                     "userC",
 *                     "SELECT",
 *                     "tableId_4"))
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .ruleId("VA1001")
 *             .sqlPoolName("testdb")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("vulnerabilityaseessmenttest-6440")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPoolVulnerabilityAssessmentRuleBaseline default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}
 * ```
 * @property baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for workspace level rule).
 * @property baselineResults The rule baseline result
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleId The vulnerability assessment rule ID.
 * @property sqlPoolName SQL pool name
 * @property vulnerabilityAssessmentName The name of the vulnerability assessment.
 * @property workspaceName The name of the workspace.
 */
public data class SqlPoolVulnerabilityAssessmentRuleBaselineArgs(
    public val baselineName: Output<String>? = null,
    public val baselineResults: Output<List<SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleId: Output<String>? = null,
    public val sqlPoolName: Output<String>? = null,
    public val vulnerabilityAssessmentName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentRuleBaselineArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentRuleBaselineArgs =
        com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentRuleBaselineArgs.builder()
            .baselineName(baselineName?.applyValue({ args0 -> args0 }))
            .baselineResults(
                baselineResults?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .sqlPoolName(sqlPoolName?.applyValue({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlPoolVulnerabilityAssessmentRuleBaselineArgs].
 */
@PulumiTagMarker
public class SqlPoolVulnerabilityAssessmentRuleBaselineArgsBuilder internal constructor() {
    private var baselineName: Output<String>? = null

    private var baselineResults: Output<List<SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs>>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var ruleId: Output<String>? = null

    private var sqlPoolName: Output<String>? = null

    private var vulnerabilityAssessmentName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for workspace level rule).
     */
    @JvmName("fhalgsxrcdpglaap")
    public suspend fun baselineName(`value`: Output<String>) {
        this.baselineName = value
    }

    /**
     * @param value The rule baseline result
     */
    @JvmName("txuysnxdrjkcvfrd")
    public suspend
    fun baselineResults(`value`: Output<List<SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs>>) {
        this.baselineResults = value
    }

    @JvmName("cqkimgiqtefqrtxt")
    public suspend fun baselineResults(
        vararg
        values: Output<SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs>,
    ) {
        this.baselineResults = Output.all(values.asList())
    }

    /**
     * @param values The rule baseline result
     */
    @JvmName("axbbsbmyiwmtqfka")
    public suspend
    fun baselineResults(values: List<Output<SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs>>) {
        this.baselineResults = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vvdxdvwamtcwwyno")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The vulnerability assessment rule ID.
     */
    @JvmName("olqahgkmdcwkmiap")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("xtaurwknltbqxttf")
    public suspend fun sqlPoolName(`value`: Output<String>) {
        this.sqlPoolName = value
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("aquanxitoohaxqfx")
    public suspend fun vulnerabilityAssessmentName(`value`: Output<String>) {
        this.vulnerabilityAssessmentName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("tbwtwixojuqurktq")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for workspace level rule).
     */
    @JvmName("pjaqoydyenevoaes")
    public suspend fun baselineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineName = mapped
    }

    /**
     * @param value The rule baseline result
     */
    @JvmName("honwferwggelgsct")
    public suspend
    fun baselineResults(`value`: List<SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineResults = mapped
    }

    /**
     * @param argument The rule baseline result
     */
    @JvmName("riyrdnlicbmnsjeq")
    public suspend
    fun baselineResults(argument: List<suspend SqlPoolVulnerabilityAssessmentRuleBaselineItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SqlPoolVulnerabilityAssessmentRuleBaselineItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.baselineResults = mapped
    }

    /**
     * @param argument The rule baseline result
     */
    @JvmName("oqrcmlxgdaaiolln")
    public suspend fun baselineResults(
        vararg
        argument: suspend SqlPoolVulnerabilityAssessmentRuleBaselineItemArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SqlPoolVulnerabilityAssessmentRuleBaselineItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.baselineResults = mapped
    }

    /**
     * @param argument The rule baseline result
     */
    @JvmName("wpqvaamlvevkrjel")
    public suspend
    fun baselineResults(argument: suspend SqlPoolVulnerabilityAssessmentRuleBaselineItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SqlPoolVulnerabilityAssessmentRuleBaselineItemArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.baselineResults = mapped
    }

    /**
     * @param values The rule baseline result
     */
    @JvmName("imigojwmywbwpnsp")
    public suspend fun baselineResults(
        vararg
        values: SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baselineResults = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lcqmsivlkcevkiyx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The vulnerability assessment rule ID.
     */
    @JvmName("tpktnvgwqnifaxvn")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("hbbwyqmjbyqmdxcg")
    public suspend fun sqlPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlPoolName = mapped
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("xdoucwbqpexrbekc")
    public suspend fun vulnerabilityAssessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vulnerabilityAssessmentName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("sbohyxonqmvoraca")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): SqlPoolVulnerabilityAssessmentRuleBaselineArgs =
        SqlPoolVulnerabilityAssessmentRuleBaselineArgs(
            baselineName = baselineName,
            baselineResults = baselineResults,
            resourceGroupName = resourceGroupName,
            ruleId = ruleId,
            sqlPoolName = sqlPoolName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
            workspaceName = workspaceName,
        )
}
