@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the mode of sql pool creation.
 * Default: regular sql pool creation.
 * PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and restorePointInTime must be specified.
 * Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as the recoverableDatabaseId to restore.
 * Restore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be specified.
 */
public enum class CreateMode(
    public val javaValue: com.pulumi.azurenative.synapse.enums.CreateMode,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.enums.CreateMode> {
    Default(com.pulumi.azurenative.synapse.enums.CreateMode.Default),
    PointInTimeRestore(com.pulumi.azurenative.synapse.enums.CreateMode.PointInTimeRestore),
    Recovery(com.pulumi.azurenative.synapse.enums.CreateMode.Recovery),
    Restore(com.pulumi.azurenative.synapse.enums.CreateMode.Restore),
    ;

    override fun toJava(): com.pulumi.azurenative.synapse.enums.CreateMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.enums.CreateMode): CreateMode =
            CreateMode.values().first { it.javaValue == javaType }
    }
}
