@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The level of compute power that each node in the Big Data pool has.
 */
public enum class NodeSize(
    public val javaValue: com.pulumi.azurenative.synapse.enums.NodeSize,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.enums.NodeSize> {
    None(com.pulumi.azurenative.synapse.enums.NodeSize.None),
    Small(com.pulumi.azurenative.synapse.enums.NodeSize.Small),
    Medium(com.pulumi.azurenative.synapse.enums.NodeSize.Medium),
    Large(com.pulumi.azurenative.synapse.enums.NodeSize.Large),
    XLarge(com.pulumi.azurenative.synapse.enums.NodeSize.XLarge),
    XXLarge(com.pulumi.azurenative.synapse.enums.NodeSize.XXLarge),
    XXXLarge(com.pulumi.azurenative.synapse.enums.NodeSize.XXXLarge),
    ;

    override fun toJava(): com.pulumi.azurenative.synapse.enums.NodeSize = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.enums.NodeSize): NodeSize =
            NodeSize.values().first { it.javaValue == javaType }
    }
}
