@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.CustomerManagedKeyDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Details of the customer managed key associated with the workspace
 * @property kekIdentity Key encryption key
 * @property key The key object of the workspace
 */
public data class CustomerManagedKeyDetailsArgs(
    public val kekIdentity: Output<KekIdentityPropertiesArgs>? = null,
    public val key: Output<WorkspaceKeyDetailsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.CustomerManagedKeyDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.CustomerManagedKeyDetailsArgs =
        com.pulumi.azurenative.synapse.inputs.CustomerManagedKeyDetailsArgs.builder()
            .kekIdentity(kekIdentity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .key(key?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CustomerManagedKeyDetailsArgs].
 */
@PulumiTagMarker
public class CustomerManagedKeyDetailsArgsBuilder internal constructor() {
    private var kekIdentity: Output<KekIdentityPropertiesArgs>? = null

    private var key: Output<WorkspaceKeyDetailsArgs>? = null

    /**
     * @param value Key encryption key
     */
    @JvmName("xrtlhbtoxjymqdec")
    public suspend fun kekIdentity(`value`: Output<KekIdentityPropertiesArgs>) {
        this.kekIdentity = value
    }

    /**
     * @param value The key object of the workspace
     */
    @JvmName("uyaclgekannqgfom")
    public suspend fun key(`value`: Output<WorkspaceKeyDetailsArgs>) {
        this.key = value
    }

    /**
     * @param value Key encryption key
     */
    @JvmName("yudmmvejjwwglugd")
    public suspend fun kekIdentity(`value`: KekIdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kekIdentity = mapped
    }

    /**
     * @param argument Key encryption key
     */
    @JvmName("vluusmvybcveeoab")
    public suspend fun kekIdentity(argument: suspend KekIdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KekIdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kekIdentity = mapped
    }

    /**
     * @param value The key object of the workspace
     */
    @JvmName("dmsoxykgphufowbl")
    public suspend fun key(`value`: WorkspaceKeyDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param argument The key object of the workspace
     */
    @JvmName("eqpjvtnhjarwkcah")
    public suspend fun key(argument: suspend WorkspaceKeyDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceKeyDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.key = mapped
    }

    internal fun build(): CustomerManagedKeyDetailsArgs = CustomerManagedKeyDetailsArgs(
        kekIdentity = kekIdentity,
        key = key,
    )
}
