@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetReadOnlyFollowingDatabasePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database in the Kusto pool.
 * @property kustoPoolName The name of the Kusto pool.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetReadOnlyFollowingDatabasePlainArgs(
    public val databaseName: String,
    public val kustoPoolName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetReadOnlyFollowingDatabasePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.GetReadOnlyFollowingDatabasePlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetReadOnlyFollowingDatabasePlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .kustoPoolName(kustoPoolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReadOnlyFollowingDatabasePlainArgs].
 */
@PulumiTagMarker
public class GetReadOnlyFollowingDatabasePlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var kustoPoolName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("sxoxfvedehdkoaba")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("xbskwtrcrwipbinu")
    public suspend fun kustoPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kustoPoolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hyoyesxdfcvdetie")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ijugfmpcpvoaavdv")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetReadOnlyFollowingDatabasePlainArgs =
        GetReadOnlyFollowingDatabasePlainArgs(
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            kustoPoolName = kustoPoolName ?: throw PulumiNullFieldException("kustoPoolName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
