@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule).
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleId The vulnerability assessment rule ID.
 * @property sqlPoolName SQL pool name
 * @property vulnerabilityAssessmentName The name of the vulnerability assessment.
 * @property workspaceName The name of the workspace.
 */
public data class GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgs(
    public val baselineName: String,
    public val resourceGroupName: String,
    public val ruleId: String,
    public val sqlPoolName: String,
    public val vulnerabilityAssessmentName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.inputs.GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgs.builder()
            .baselineName(baselineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleId(ruleId.let({ args0 -> args0 }))
            .sqlPoolName(sqlPoolName.let({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgs].
 */
@PulumiTagMarker
public class GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgsBuilder internal constructor() {
    private var baselineName: String? = null

    private var resourceGroupName: String? = null

    private var ruleId: String? = null

    private var sqlPoolName: String? = null

    private var vulnerabilityAssessmentName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule).
     */
    @JvmName("cldempvlensdtuvx")
    public suspend fun baselineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.baselineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("plytmgtdsexbvwwy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The vulnerability assessment rule ID.
     */
    @JvmName("mqnmbyorbltdnhod")
    public suspend fun ruleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleId = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("edblwfkqyjotyvha")
    public suspend fun sqlPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlPoolName = mapped
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("mvplujiuqlubghcl")
    public suspend fun vulnerabilityAssessmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vulnerabilityAssessmentName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("mxoapcjfdjdfdscl")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgs =
        GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgs(
            baselineName = baselineName ?: throw PulumiNullFieldException("baselineName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            ruleId = ruleId ?: throw PulumiNullFieldException("ruleId"),
            sqlPoolName = sqlPoolName ?: throw PulumiNullFieldException("sqlPoolName"),
            vulnerabilityAssessmentName = vulnerabilityAssessmentName ?: throw
                PulumiNullFieldException("vulnerabilityAssessmentName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
