@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vulnerabilityAssessmentName The name of the vulnerability assessment.
 * @property workspaceName The name of the workspace.
 */
public data class GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgs(
    public val resourceGroupName: String,
    public val vulnerabilityAssessmentName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.inputs.GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgsBuilder internal
constructor() {
    private var resourceGroupName: String? = null

    private var vulnerabilityAssessmentName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("adrdyovhsjujvxwa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("vvxmrenwkiecysgg")
    public suspend fun vulnerabilityAssessmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vulnerabilityAssessmentName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("bdpknasigejnscrd")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgs =
        GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            vulnerabilityAssessmentName = vulnerabilityAssessmentName ?: throw
                PulumiNullFieldException("vulnerabilityAssessmentName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
