@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeSsisPropertiesArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.IntegrationRuntimeEdition
import com.pulumi.azurenative.synapse.kotlin.enums.IntegrationRuntimeLicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SSIS properties for managed integration runtime.
 * @property catalogInfo Catalog information for managed dedicated integration runtime.
 * @property customSetupScriptProperties Custom setup script properties for a managed dedicated integration runtime.
 * @property dataProxyProperties Data proxy properties for a managed dedicated integration runtime.
 * @property edition The edition for the SSIS Integration Runtime
 * @property expressCustomSetupProperties Custom setup without script properties for a SSIS integration runtime.
 * @property licenseType License type for bringing your own license scenario.
 */
public data class IntegrationRuntimeSsisPropertiesArgs(
    public val catalogInfo: Output<IntegrationRuntimeSsisCatalogInfoArgs>? = null,
    public val customSetupScriptProperties: Output<IntegrationRuntimeCustomSetupScriptPropertiesArgs>? =
        null,
    public val dataProxyProperties: Output<IntegrationRuntimeDataProxyPropertiesArgs>? = null,
    public val edition: Output<Either<String, IntegrationRuntimeEdition>>? = null,
    public val expressCustomSetupProperties: Output<List<Any>>? = null,
    public val licenseType: Output<Either<String, IntegrationRuntimeLicenseType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeSsisPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeSsisPropertiesArgs =
        com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeSsisPropertiesArgs.builder()
            .catalogInfo(catalogInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customSetupScriptProperties(
                customSetupScriptProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataProxyProperties(
                dataProxyProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .edition(
                edition?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .expressCustomSetupProperties(
                expressCustomSetupProperties?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [IntegrationRuntimeSsisPropertiesArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeSsisPropertiesArgsBuilder internal constructor() {
    private var catalogInfo: Output<IntegrationRuntimeSsisCatalogInfoArgs>? = null

    private var customSetupScriptProperties:
        Output<IntegrationRuntimeCustomSetupScriptPropertiesArgs>? = null

    private var dataProxyProperties: Output<IntegrationRuntimeDataProxyPropertiesArgs>? = null

    private var edition: Output<Either<String, IntegrationRuntimeEdition>>? = null

    private var expressCustomSetupProperties: Output<List<Any>>? = null

    private var licenseType: Output<Either<String, IntegrationRuntimeLicenseType>>? = null

    /**
     * @param value Catalog information for managed dedicated integration runtime.
     */
    @JvmName("ygihlancodjpopol")
    public suspend fun catalogInfo(`value`: Output<IntegrationRuntimeSsisCatalogInfoArgs>) {
        this.catalogInfo = value
    }

    /**
     * @param value Custom setup script properties for a managed dedicated integration runtime.
     */
    @JvmName("gpawuexukjwyaaok")
    public suspend
    fun customSetupScriptProperties(`value`: Output<IntegrationRuntimeCustomSetupScriptPropertiesArgs>) {
        this.customSetupScriptProperties = value
    }

    /**
     * @param value Data proxy properties for a managed dedicated integration runtime.
     */
    @JvmName("ltgewshpdlkitemv")
    public suspend
    fun dataProxyProperties(`value`: Output<IntegrationRuntimeDataProxyPropertiesArgs>) {
        this.dataProxyProperties = value
    }

    /**
     * @param value The edition for the SSIS Integration Runtime
     */
    @JvmName("ycffrxkjmcmljfvm")
    public suspend fun edition(`value`: Output<Either<String, IntegrationRuntimeEdition>>) {
        this.edition = value
    }

    /**
     * @param value Custom setup without script properties for a SSIS integration runtime.
     */
    @JvmName("pvmwdoquqtjowyqo")
    public suspend fun expressCustomSetupProperties(`value`: Output<List<Any>>) {
        this.expressCustomSetupProperties = value
    }

    @JvmName("qofxwgowahhfnolf")
    public suspend fun expressCustomSetupProperties(vararg values: Output<Any>) {
        this.expressCustomSetupProperties = Output.all(values.asList())
    }

    /**
     * @param values Custom setup without script properties for a SSIS integration runtime.
     */
    @JvmName("naxqawtkfnhjhewb")
    public suspend fun expressCustomSetupProperties(values: List<Output<Any>>) {
        this.expressCustomSetupProperties = Output.all(values)
    }

    /**
     * @param value License type for bringing your own license scenario.
     */
    @JvmName("qfpgjhticqlbvsdb")
    public suspend fun licenseType(`value`: Output<Either<String, IntegrationRuntimeLicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value Catalog information for managed dedicated integration runtime.
     */
    @JvmName("hmgxfsdjilmantdp")
    public suspend fun catalogInfo(`value`: IntegrationRuntimeSsisCatalogInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogInfo = mapped
    }

    /**
     * @param argument Catalog information for managed dedicated integration runtime.
     */
    @JvmName("grlgebmdmdoawkxl")
    public suspend
    fun catalogInfo(argument: suspend IntegrationRuntimeSsisCatalogInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeSsisCatalogInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.catalogInfo = mapped
    }

    /**
     * @param value Custom setup script properties for a managed dedicated integration runtime.
     */
    @JvmName("lnibncvmmpjobtky")
    public suspend
    fun customSetupScriptProperties(`value`: IntegrationRuntimeCustomSetupScriptPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSetupScriptProperties = mapped
    }

    /**
     * @param argument Custom setup script properties for a managed dedicated integration runtime.
     */
    @JvmName("ukywchmgtvkbagne")
    public suspend
    fun customSetupScriptProperties(argument: suspend IntegrationRuntimeCustomSetupScriptPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeCustomSetupScriptPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customSetupScriptProperties = mapped
    }

    /**
     * @param value Data proxy properties for a managed dedicated integration runtime.
     */
    @JvmName("ajwthqkhwbluywqs")
    public suspend fun dataProxyProperties(`value`: IntegrationRuntimeDataProxyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataProxyProperties = mapped
    }

    /**
     * @param argument Data proxy properties for a managed dedicated integration runtime.
     */
    @JvmName("xyfddhbgqbmiixes")
    public suspend
    fun dataProxyProperties(argument: suspend IntegrationRuntimeDataProxyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeDataProxyPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataProxyProperties = mapped
    }

    /**
     * @param value The edition for the SSIS Integration Runtime
     */
    @JvmName("jyurpbhrhadjkbgk")
    public suspend fun edition(`value`: Either<String, IntegrationRuntimeEdition>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value The edition for the SSIS Integration Runtime
     */
    @JvmName("nclrafbutpdyvxjm")
    public fun edition(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IntegrationRuntimeEdition>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value The edition for the SSIS Integration Runtime
     */
    @JvmName("eaisestnbwvlbdfv")
    public fun edition(`value`: IntegrationRuntimeEdition) {
        val toBeMapped = Either.ofRight<String, IntegrationRuntimeEdition>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value Custom setup without script properties for a SSIS integration runtime.
     */
    @JvmName("uywuxjnwcgxsptqd")
    public suspend fun expressCustomSetupProperties(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressCustomSetupProperties = mapped
    }

    /**
     * @param values Custom setup without script properties for a SSIS integration runtime.
     */
    @JvmName("tslroxtyrhrmiddn")
    public suspend fun expressCustomSetupProperties(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expressCustomSetupProperties = mapped
    }

    /**
     * @param value License type for bringing your own license scenario.
     */
    @JvmName("idjqgywxttokdvvy")
    public suspend fun licenseType(`value`: Either<String, IntegrationRuntimeLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value License type for bringing your own license scenario.
     */
    @JvmName("ohbpfveatwsoihce")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IntegrationRuntimeLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value License type for bringing your own license scenario.
     */
    @JvmName("gunfmhsvrebajsgk")
    public fun licenseType(`value`: IntegrationRuntimeLicenseType) {
        val toBeMapped = Either.ofRight<String, IntegrationRuntimeLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    internal fun build(): IntegrationRuntimeSsisPropertiesArgs = IntegrationRuntimeSsisPropertiesArgs(
        catalogInfo = catalogInfo,
        customSetupScriptProperties = customSetupScriptProperties,
        dataProxyProperties = dataProxyProperties,
        edition = edition,
        expressCustomSetupProperties = expressCustomSetupProperties,
        licenseType = licenseType,
    )
}
