@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.LibraryInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Library/package information of a Big Data pool powered by Apache Spark
 * @property containerName Storage blob container name.
 * @property name Name of the library.
 * @property path Storage blob path of library.
 * @property type Type of the library.
 */
public data class LibraryInfoArgs(
    public val containerName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val path: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.LibraryInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.LibraryInfoArgs =
        com.pulumi.azurenative.synapse.inputs.LibraryInfoArgs.builder()
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LibraryInfoArgs].
 */
@PulumiTagMarker
public class LibraryInfoArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var name: Output<String>? = null

    private var path: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Storage blob container name.
     */
    @JvmName("khtwbpwhsiefqvea")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Name of the library.
     */
    @JvmName("vlcngdnwqygwcxoh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Storage blob path of library.
     */
    @JvmName("kuwlfyadmhbasqyy")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Type of the library.
     */
    @JvmName("mylikjhhitvmhebl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Storage blob container name.
     */
    @JvmName("heluntiafpldxobq")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Name of the library.
     */
    @JvmName("ktumihnktafafqgg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Storage blob path of library.
     */
    @JvmName("nqhlphxhtvuvnnif")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Type of the library.
     */
    @JvmName("slhgkcywxuwvinai")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): LibraryInfoArgs = LibraryInfoArgs(
        containerName = containerName,
        name = name,
        path = path,
        type = type,
    )
}
