@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.PrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connection state details of the private endpoint
 * @property description The private link service connection description.
 * @property status The private link service connection status.
 */
public data class PrivateLinkServiceConnectionStateArgs(
    public val description: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.PrivateLinkServiceConnectionStateArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.PrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.synapse.inputs.PrivateLinkServiceConnectionStateArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The private link service connection description.
     */
    @JvmName("qymuujdxdoirfcsr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("yfkwxxjyytxtawfa")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The private link service connection description.
     */
    @JvmName("vfwkqvmdndnyyrfi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("atdikeipyrkmdrnc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStateArgs =
        PrivateLinkServiceConnectionStateArgs(
            description = description,
            status = status,
        )
}
