@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.SparkConfigPropertiesArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.ConfigurationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SparkConfig Properties for a Big Data pool powered by Apache Spark
 * @property configurationType The type of the spark config properties file.
 * @property content The spark config properties.
 * @property filename The filename of the spark config properties file.
 */
public data class SparkConfigPropertiesArgs(
    public val configurationType: Output<Either<String, ConfigurationType>>? = null,
    public val content: Output<String>? = null,
    public val filename: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.SparkConfigPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.SparkConfigPropertiesArgs =
        com.pulumi.azurenative.synapse.inputs.SparkConfigPropertiesArgs.builder()
            .configurationType(
                configurationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .content(content?.applyValue({ args0 -> args0 }))
            .filename(filename?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SparkConfigPropertiesArgs].
 */
@PulumiTagMarker
public class SparkConfigPropertiesArgsBuilder internal constructor() {
    private var configurationType: Output<Either<String, ConfigurationType>>? = null

    private var content: Output<String>? = null

    private var filename: Output<String>? = null

    /**
     * @param value The type of the spark config properties file.
     */
    @JvmName("rvyvnwrnrahcsers")
    public suspend fun configurationType(`value`: Output<Either<String, ConfigurationType>>) {
        this.configurationType = value
    }

    /**
     * @param value The spark config properties.
     */
    @JvmName("usbymajleycbtggd")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The filename of the spark config properties file.
     */
    @JvmName("yllgdusrwsutkyqm")
    public suspend fun filename(`value`: Output<String>) {
        this.filename = value
    }

    /**
     * @param value The type of the spark config properties file.
     */
    @JvmName("twnofmbqbclpajts")
    public suspend fun configurationType(`value`: Either<String, ConfigurationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value The type of the spark config properties file.
     */
    @JvmName("ewngnhkniklgocxv")
    public fun configurationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value The type of the spark config properties file.
     */
    @JvmName("dhtbltbixysvqvnp")
    public fun configurationType(`value`: ConfigurationType) {
        val toBeMapped = Either.ofRight<String, ConfigurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value The spark config properties.
     */
    @JvmName("udbrxwxnmtntaaxy")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The filename of the spark config properties file.
     */
    @JvmName("mgtlmfekrnbueyga")
    public suspend fun filename(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filename = mapped
    }

    internal fun build(): SparkConfigPropertiesArgs = SparkConfigPropertiesArgs(
        configurationType = configurationType,
        content = content,
        filename = filename,
    )
}
