@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of a Vulnerability Assessment recurring scans.
 * @property emailSubscriptionAdmins Specifies that the schedule scan notification will be is sent to the subscription administrators.
 * @property emails Specifies an array of e-mail addresses to which the scan notification is sent.
 * @property isEnabled Recurring scans state.
 */
public data class VulnerabilityAssessmentRecurringScansPropertiesArgs(
    public val emailSubscriptionAdmins: Output<Boolean>? = null,
    public val emails: Output<List<String>>? = null,
    public val isEnabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs =
        com.pulumi.azurenative.synapse.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs.builder()
            .emailSubscriptionAdmins(emailSubscriptionAdmins?.applyValue({ args0 -> args0 }))
            .emails(emails?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VulnerabilityAssessmentRecurringScansPropertiesArgs].
 */
@PulumiTagMarker
public class VulnerabilityAssessmentRecurringScansPropertiesArgsBuilder internal constructor() {
    private var emailSubscriptionAdmins: Output<Boolean>? = null

    private var emails: Output<List<String>>? = null

    private var isEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies that the schedule scan notification will be is sent to the subscription administrators.
     */
    @JvmName("lbmlfyagqsumyosa")
    public suspend fun emailSubscriptionAdmins(`value`: Output<Boolean>) {
        this.emailSubscriptionAdmins = value
    }

    /**
     * @param value Specifies an array of e-mail addresses to which the scan notification is sent.
     */
    @JvmName("eqccwkjujmbvusul")
    public suspend fun emails(`value`: Output<List<String>>) {
        this.emails = value
    }

    @JvmName("tnxtnmduamtekspi")
    public suspend fun emails(vararg values: Output<String>) {
        this.emails = Output.all(values.asList())
    }

    /**
     * @param values Specifies an array of e-mail addresses to which the scan notification is sent.
     */
    @JvmName("rvelwydaajudbqni")
    public suspend fun emails(values: List<Output<String>>) {
        this.emails = Output.all(values)
    }

    /**
     * @param value Recurring scans state.
     */
    @JvmName("ixhnhkekxhmilodd")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Specifies that the schedule scan notification will be is sent to the subscription administrators.
     */
    @JvmName("pxcgoofbowsoatdt")
    public suspend fun emailSubscriptionAdmins(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailSubscriptionAdmins = mapped
    }

    /**
     * @param value Specifies an array of e-mail addresses to which the scan notification is sent.
     */
    @JvmName("fvvghcgukqgbptqr")
    public suspend fun emails(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emails = mapped
    }

    /**
     * @param values Specifies an array of e-mail addresses to which the scan notification is sent.
     */
    @JvmName("ffakcxhvalwyhhgt")
    public suspend fun emails(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emails = mapped
    }

    /**
     * @param value Recurring scans state.
     */
    @JvmName("yrstskhwvqgtismi")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    internal fun build(): VulnerabilityAssessmentRecurringScansPropertiesArgs =
        VulnerabilityAssessmentRecurringScansPropertiesArgs(
            emailSubscriptionAdmins = emailSubscriptionAdmins,
            emails = emails,
            isEnabled = isEnabled,
        )
}
