@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Auto-scaling properties of a Big Data pool powered by Apache Spark
 * @property enabled Whether automatic scaling is enabled for the Big Data pool.
 * @property maxNodeCount The maximum number of nodes the Big Data pool can support.
 * @property minNodeCount The minimum number of nodes the Big Data pool can support.
 */
public data class AutoScalePropertiesResponse(
    public val enabled: Boolean? = null,
    public val maxNodeCount: Int? = null,
    public val minNodeCount: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.AutoScalePropertiesResponse):
            AutoScalePropertiesResponse = AutoScalePropertiesResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            maxNodeCount = javaType.maxNodeCount().map({ args0 -> args0 }).orElse(null),
            minNodeCount = javaType.minNodeCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
