@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the customer managed key associated with the workspace
 * @property kekIdentity Key encryption key
 * @property key The key object of the workspace
 * @property status The customer managed key status on the workspace
 */
public data class CustomerManagedKeyDetailsResponse(
    public val kekIdentity: KekIdentityPropertiesResponse? = null,
    public val key: WorkspaceKeyDetailsResponse? = null,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.CustomerManagedKeyDetailsResponse):
            CustomerManagedKeyDetailsResponse = CustomerManagedKeyDetailsResponse(
            kekIdentity = javaType.kekIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.KekIdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            key = javaType.key().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.WorkspaceKeyDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
        )
    }
}
