@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Class representing a Kusto kusto pool.
 * @property dataIngestionUri The Kusto Pool data ingestion URI.
 * @property enablePurge A boolean value that indicates if the purge operations are enabled.
 * @property enableStreamingIngest A boolean value that indicates if the streaming ingest is enabled.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property languageExtensions List of the Kusto Pool's language extensions.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property optimizedAutoscale Optimized auto scale definition.
 * @property provisioningState The provisioned state of the resource.
 * @property sku The SKU of the kusto pool.
 * @property state The state of the resource.
 * @property stateReason The reason for the Kusto Pool's current state.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property uri The Kusto Pool URI.
 * @property workspaceUID The workspace unique identifier.
 */
public data class GetKustoPoolResult(
    public val dataIngestionUri: String,
    public val enablePurge: Boolean? = null,
    public val enableStreamingIngest: Boolean? = null,
    public val etag: String,
    public val id: String,
    public val languageExtensions: LanguageExtensionsListResponse,
    public val location: String,
    public val name: String,
    public val optimizedAutoscale: OptimizedAutoscaleResponse? = null,
    public val provisioningState: String,
    public val sku: AzureSkuResponse,
    public val state: String,
    public val stateReason: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uri: String,
    public val workspaceUID: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetKustoPoolResult):
            GetKustoPoolResult = GetKustoPoolResult(
            dataIngestionUri = javaType.dataIngestionUri(),
            enablePurge = javaType.enablePurge().map({ args0 -> args0 }).orElse(null),
            enableStreamingIngest = javaType.enableStreamingIngest().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            languageExtensions = javaType.languageExtensions().let({ args0 ->
                com.pulumi.azurenative.synapse.kotlin.outputs.LanguageExtensionsListResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            optimizedAutoscale = javaType.optimizedAutoscale().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.OptimizedAutoscaleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.synapse.kotlin.outputs.AzureSkuResponse.Companion.toKotlin(args0)
            }),
            state = javaType.state(),
            stateReason = javaType.stateReason(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uri = javaType.uri(),
            workspaceUID = javaType.workspaceUID().map({ args0 -> args0 }).orElse(null),
        )
    }
}
