@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class representing a read only following database.
 * @property attachedDatabaseConfigurationName The name of the attached database configuration cluster
 * @property hotCachePeriod The time the data should be kept in cache for fast queries in TimeSpan.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind Kind of the database
 * Expected value is 'ReadOnlyFollowing'.
 * @property leaderClusterResourceId The name of the leader cluster
 * @property location Resource location.
 * @property name The name of the resource
 * @property principalsModificationKind The principals modification kind of the database
 * @property provisioningState The provisioned state of the resource.
 * @property softDeletePeriod The time the data should be kept before it stops being accessible to queries in TimeSpan.
 * @property statistics The statistics of the database.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetReadOnlyFollowingDatabaseResult(
    public val attachedDatabaseConfigurationName: String,
    public val hotCachePeriod: String? = null,
    public val id: String,
    public val kind: String,
    public val leaderClusterResourceId: String,
    public val location: String? = null,
    public val name: String,
    public val principalsModificationKind: String,
    public val provisioningState: String,
    public val softDeletePeriod: String,
    public val statistics: DatabaseStatisticsResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetReadOnlyFollowingDatabaseResult):
            GetReadOnlyFollowingDatabaseResult = GetReadOnlyFollowingDatabaseResult(
            attachedDatabaseConfigurationName = javaType.attachedDatabaseConfigurationName(),
            hotCachePeriod = javaType.hotCachePeriod().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            leaderClusterResourceId = javaType.leaderClusterResourceId(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            principalsModificationKind = javaType.principalsModificationKind(),
            provisioningState = javaType.provisioningState(),
            softDeletePeriod = javaType.softDeletePeriod(),
            statistics = javaType.statistics().let({ args0 ->
                com.pulumi.azurenative.synapse.kotlin.outputs.DatabaseStatisticsResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
