@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a Sql pool transparent data encryption configuration.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location Resource location.
 * @property name The name of the resource
 * @property status The status of the database transparent data encryption.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSqlPoolTransparentDataEncryptionResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val status: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetSqlPoolTransparentDataEncryptionResult):
            GetSqlPoolTransparentDataEncryptionResult = GetSqlPoolTransparentDataEncryptionResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
