@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Library requirements for a Big Data pool powered by Apache Spark
 * @property content The library requirements.
 * @property filename The filename of the library requirements file.
 * @property time The last update time of the library requirements file.
 */
public data class LibraryRequirementsResponse(
    public val content: String? = null,
    public val filename: String? = null,
    public val time: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.LibraryRequirementsResponse):
            LibraryRequirementsResponse = LibraryRequirementsResponse(
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            filename = javaType.filename().map({ args0 -> args0 }).orElse(null),
            time = javaType.time(),
        )
    }
}
