@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Error definition for managed integration runtime.
 * @property code Error code.
 * @property message Error message.
 * @property parameters Managed integration runtime error parameters.
 * @property time The time when the error occurred.
 */
public data class ManagedIntegrationRuntimeErrorResponse(
    public val code: String,
    public val message: String,
    public val parameters: List<String>,
    public val time: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.ManagedIntegrationRuntimeErrorResponse):
            ManagedIntegrationRuntimeErrorResponse = ManagedIntegrationRuntimeErrorResponse(
            code = javaType.code(),
            message = javaType.message(),
            parameters = javaType.parameters().map({ args0 -> args0 }),
            time = javaType.time(),
        )
    }
}
