@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of managed integration runtime operation result.
 * @property activityId The activity id for the operation request.
 * @property errorCode The error code.
 * @property parameters Managed integration runtime error parameters.
 * @property result The operation result.
 * @property startTime The start time of the operation.
 * @property type The operation type. Could be start or stop.
 */
public data class ManagedIntegrationRuntimeOperationResultResponse(
    public val activityId: String,
    public val errorCode: String,
    public val parameters: List<String>,
    public val result: String,
    public val startTime: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.ManagedIntegrationRuntimeOperationResultResponse):
            ManagedIntegrationRuntimeOperationResultResponse =
            ManagedIntegrationRuntimeOperationResultResponse(
                activityId = javaType.activityId(),
                errorCode = javaType.errorCode(),
                parameters = javaType.parameters().map({ args0 -> args0 }),
                result = javaType.result(),
                startTime = javaType.startTime(),
                type = javaType.type(),
            )
    }
}
