@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SparkConfig Properties for a Big Data pool powered by Apache Spark
 * @property configurationType The type of the spark config properties file.
 * @property content The spark config properties.
 * @property filename The filename of the spark config properties file.
 * @property time The last update time of the spark config properties file.
 */
public data class SparkConfigPropertiesResponse(
    public val configurationType: String? = null,
    public val content: String? = null,
    public val filename: String? = null,
    public val time: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.SparkConfigPropertiesResponse):
            SparkConfigPropertiesResponse = SparkConfigPropertiesResponse(
            configurationType = javaType.configurationType().map({ args0 -> args0 }).orElse(null),
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            filename = javaType.filename().map({ args0 -> args0 }).orElse(null),
            time = javaType.time(),
        )
    }
}
