@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User Assigned Managed Identity
 * @property clientId The client ID.
 * @property principalId The principal ID.
 */
public data class UserAssignedManagedIdentityResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.UserAssignedManagedIdentityResponse):
            UserAssignedManagedIdentityResponse = UserAssignedManagedIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
