@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Git integration settings
 * @property accountName Account name
 * @property collaborationBranch Collaboration branch
 * @property hostName GitHub Enterprise host name. For example: `https://github.mydomain.com`
 * @property lastCommitId The last commit ID
 * @property projectName VSTS project name
 * @property repositoryName Repository name
 * @property rootFolder Root folder to use in the repository
 * @property tenantId The VSTS tenant ID
 * @property type Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration
 */
public data class WorkspaceRepositoryConfigurationResponse(
    public val accountName: String? = null,
    public val collaborationBranch: String? = null,
    public val hostName: String? = null,
    public val lastCommitId: String? = null,
    public val projectName: String? = null,
    public val repositoryName: String? = null,
    public val rootFolder: String? = null,
    public val tenantId: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.WorkspaceRepositoryConfigurationResponse):
            WorkspaceRepositoryConfigurationResponse = WorkspaceRepositoryConfigurationResponse(
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            collaborationBranch = javaType.collaborationBranch().map({ args0 -> args0 }).orElse(null),
            hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
            lastCommitId = javaType.lastCommitId().map({ args0 -> args0 }).orElse(null),
            projectName = javaType.projectName().map({ args0 -> args0 }).orElse(null),
            repositoryName = javaType.repositoryName().map({ args0 -> args0 }).orElse(null),
            rootFolder = javaType.rootFolder().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
