@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.syntex.kotlin

import com.pulumi.azurenative.syntex.DocumentProcessorArgs.builder
import com.pulumi.azurenative.syntex.kotlin.inputs.DocumentProcessorPropertiesArgs
import com.pulumi.azurenative.syntex.kotlin.inputs.DocumentProcessorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Document processor details
 * Azure REST API version: 2022-09-15-preview. Prior API version in Azure Native 1.x: 2022-09-15-preview.
 * ## Example Usage
 * ### DocumentProcessor_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var documentProcessor = new AzureNative.Syntex.DocumentProcessor("documentProcessor", new()
 *     {
 *         Location = "westus",
 *         ProcessorName = "myprocessor",
 *         Properties = new AzureNative.Syntex.Inputs.DocumentProcessorPropertiesArgs
 *         {
 *             SpoTenantId = "e9bb744b-9558-4dc6-9e50-a3297e3332fa",
 *             SpoTenantUrl = "https://test123.sharepoint.com",
 *         },
 *         ResourceGroupName = "mygroup",
 *         Tags =
 *         {
 *             { "additionalProp1", "string1" },
 *             { "additionalProp2", "string2" },
 *             { "additionalProp3", "string3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/syntex/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := syntex.NewDocumentProcessor(ctx, "documentProcessor", &syntex.DocumentProcessorArgs{
 * 			Location:      pulumi.String("westus"),
 * 			ProcessorName: pulumi.String("myprocessor"),
 * 			Properties: &syntex.DocumentProcessorPropertiesArgs{
 * 				SpoTenantId:  pulumi.String("e9bb744b-9558-4dc6-9e50-a3297e3332fa"),
 * 				SpoTenantUrl: pulumi.String("https://test123.sharepoint.com"),
 * 			},
 * 			ResourceGroupName: pulumi.String("mygroup"),
 * 			Tags: pulumi.StringMap{
 * 				"additionalProp1": pulumi.String("string1"),
 * 				"additionalProp2": pulumi.String("string2"),
 * 				"additionalProp3": pulumi.String("string3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.syntex.DocumentProcessor;
 * import com.pulumi.azurenative.syntex.DocumentProcessorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var documentProcessor = new DocumentProcessor("documentProcessor", DocumentProcessorArgs.builder()
 *             .location("westus")
 *             .processorName("myprocessor")
 *             .properties(Map.ofEntries(
 *                 Map.entry("spoTenantId", "e9bb744b-9558-4dc6-9e50-a3297e3332fa"),
 *                 Map.entry("spoTenantUrl", "https://test123.sharepoint.com")
 *             ))
 *             .resourceGroupName("mygroup")
 *             .tags(Map.ofEntries(
 *                 Map.entry("additionalProp1", "string1"),
 *                 Map.entry("additionalProp2", "string2"),
 *                 Map.entry("additionalProp3", "string3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:syntex:DocumentProcessor myprocessor /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Syntex/documentProcessors/{processorName}
 * ```
 * @property location The geo-location where the resource lives
 * @property processorName The name of document processor resource.
 * @property properties Document processor properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class DocumentProcessorArgs(
    public val location: Output<String>? = null,
    public val processorName: Output<String>? = null,
    public val properties: Output<DocumentProcessorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.syntex.DocumentProcessorArgs> {
    override fun toJava(): com.pulumi.azurenative.syntex.DocumentProcessorArgs =
        com.pulumi.azurenative.syntex.DocumentProcessorArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .processorName(processorName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DocumentProcessorArgs].
 */
@PulumiTagMarker
public class DocumentProcessorArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var processorName: Output<String>? = null

    private var properties: Output<DocumentProcessorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("danrbiqjbswlhgxe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of document processor resource.
     */
    @JvmName("oehbtdwptxnnyeia")
    public suspend fun processorName(`value`: Output<String>) {
        this.processorName = value
    }

    /**
     * @param value Document processor properties.
     */
    @JvmName("vlrkhrqawixtwlhr")
    public suspend fun properties(`value`: Output<DocumentProcessorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eefpibojeugvqucx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gdimogoqhptfaybn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dpsrfpbbklcmyovm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of document processor resource.
     */
    @JvmName("acdxjiokmjfmxrlm")
    public suspend fun processorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processorName = mapped
    }

    /**
     * @param value Document processor properties.
     */
    @JvmName("egxkxnucuyqyxdpc")
    public suspend fun properties(`value`: DocumentProcessorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Document processor properties.
     */
    @JvmName("mapdfcwulrlyswun")
    public suspend
    fun properties(argument: suspend DocumentProcessorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DocumentProcessorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jiofcwxefkgprkqe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nubcrkliximynywo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("mqygpdenwwmkbwxb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DocumentProcessorArgs = DocumentProcessorArgs(
        location = location,
        processorName = processorName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
