@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.CustomerEventArgs.builder
import com.pulumi.azurenative.testbase.kotlin.inputs.NotificationEventReceiverArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.NotificationEventReceiverArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Customer Notification Event resource.
 * Azure REST API version: 2022-04-01-preview. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * ## Example Usage
 * ### CustomerEventCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customerEvent = new AzureNative.TestBase.CustomerEvent("customerEvent", new()
 *     {
 *         CustomerEventName = "WeeklySummary",
 *         EventName = "WeeklySummary",
 *         Receivers = new[]
 *         {
 *             new AzureNative.TestBase.Inputs.NotificationEventReceiverArgs
 *             {
 *                 ReceiverType = "UserObjects",
 *                 ReceiverValue = new AzureNative.TestBase.Inputs.NotificationReceiverValueArgs
 *                 {
 *                     UserObjectReceiverValue = new AzureNative.TestBase.Inputs.UserObjectReceiverValueArgs
 *                     {
 *                         UserObjectIds = new[]
 *                         {
 *                             "245245245245325",
 *                             "365365365363565",
 *                         },
 *                     },
 *                 },
 *             },
 *             new AzureNative.TestBase.Inputs.NotificationEventReceiverArgs
 *             {
 *                 ReceiverType = "DistributionGroup",
 *                 ReceiverValue = new AzureNative.TestBase.Inputs.NotificationReceiverValueArgs
 *                 {
 *                     DistributionGroupListReceiverValue = new AzureNative.TestBase.Inputs.DistributionGroupListReceiverValueArgs
 *                     {
 *                         DistributionGroups = new[]
 *                         {
 *                             "test@microsoft.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "contoso-rg1",
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewCustomerEvent(ctx, "customerEvent", &testbase.CustomerEventArgs{
 * 			CustomerEventName: pulumi.String("WeeklySummary"),
 * 			EventName:         pulumi.String("WeeklySummary"),
 * 			Receivers: []testbase.NotificationEventReceiverArgs{
 * 				{
 * 					ReceiverType: pulumi.String("UserObjects"),
 * 					ReceiverValue: {
 * 						UserObjectReceiverValue: {
 * 							UserObjectIds: pulumi.StringArray{
 * 								pulumi.String("245245245245325"),
 * 								pulumi.String("365365365363565"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				{
 * 					ReceiverType: pulumi.String("DistributionGroup"),
 * 					ReceiverValue: {
 * 						DistributionGroupListReceiverValue: {
 * 							DistributionGroups: pulumi.StringArray{
 * 								pulumi.String("test@microsoft.com"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName:   pulumi.String("contoso-rg1"),
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.CustomerEvent;
 * import com.pulumi.azurenative.testbase.CustomerEventArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customerEvent = new CustomerEvent("customerEvent", CustomerEventArgs.builder()
 *             .customerEventName("WeeklySummary")
 *             .eventName("WeeklySummary")
 *             .receivers(
 *                 Map.ofEntries(
 *                     Map.entry("receiverType", "UserObjects"),
 *                     Map.entry("receiverValue", Map.of("userObjectReceiverValue", Map.of("userObjectIds",
 *                         "245245245245325",
 *                         "365365365363565")))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("receiverType", "DistributionGroup"),
 *                     Map.entry("receiverValue", Map.of("distributionGroupListReceiverValue", Map.of("distributionGroups", "test@microsoft.com")))
 *                 ))
 *             .resourceGroupName("contoso-rg1")
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:CustomerEvent WeeklySummary /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/customerEvents/{customerEventName}
 * ```
 * @property customerEventName The resource name of the Test Base Customer event.
 * @property eventName The name of the event subscribed to.
 * @property receivers The notification event receivers.
 * @property resourceGroupName The name of the resource group that contains the resource.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class CustomerEventArgs(
    public val customerEventName: Output<String>? = null,
    public val eventName: Output<String>? = null,
    public val receivers: Output<List<NotificationEventReceiverArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val testBaseAccountName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.CustomerEventArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.CustomerEventArgs =
        com.pulumi.azurenative.testbase.CustomerEventArgs.builder()
            .customerEventName(customerEventName?.applyValue({ args0 -> args0 }))
            .eventName(eventName?.applyValue({ args0 -> args0 }))
            .receivers(
                receivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomerEventArgs].
 */
@PulumiTagMarker
public class CustomerEventArgsBuilder internal constructor() {
    private var customerEventName: Output<String>? = null

    private var eventName: Output<String>? = null

    private var receivers: Output<List<NotificationEventReceiverArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var testBaseAccountName: Output<String>? = null

    /**
     * @param value The resource name of the Test Base Customer event.
     */
    @JvmName("uymbctfqcirrhatg")
    public suspend fun customerEventName(`value`: Output<String>) {
        this.customerEventName = value
    }

    /**
     * @param value The name of the event subscribed to.
     */
    @JvmName("opylxwuvkxivplqr")
    public suspend fun eventName(`value`: Output<String>) {
        this.eventName = value
    }

    /**
     * @param value The notification event receivers.
     */
    @JvmName("bfipooqhogxguulx")
    public suspend fun receivers(`value`: Output<List<NotificationEventReceiverArgs>>) {
        this.receivers = value
    }

    @JvmName("gcreeitblexduuiq")
    public suspend fun receivers(vararg values: Output<NotificationEventReceiverArgs>) {
        this.receivers = Output.all(values.asList())
    }

    /**
     * @param values The notification event receivers.
     */
    @JvmName("eqexscmacmhfpegq")
    public suspend fun receivers(values: List<Output<NotificationEventReceiverArgs>>) {
        this.receivers = Output.all(values)
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("nognjqjwmxfoayft")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("siepypspqulpolkg")
    public suspend fun testBaseAccountName(`value`: Output<String>) {
        this.testBaseAccountName = value
    }

    /**
     * @param value The resource name of the Test Base Customer event.
     */
    @JvmName("xemdiwtjpyekahao")
    public suspend fun customerEventName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerEventName = mapped
    }

    /**
     * @param value The name of the event subscribed to.
     */
    @JvmName("rbbknnlfialeoumi")
    public suspend fun eventName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventName = mapped
    }

    /**
     * @param value The notification event receivers.
     */
    @JvmName("ejkgiesssfcmrxpp")
    public suspend fun receivers(`value`: List<NotificationEventReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receivers = mapped
    }

    /**
     * @param argument The notification event receivers.
     */
    @JvmName("tqndvmxskmfwbxgi")
    public suspend
    fun receivers(argument: List<suspend NotificationEventReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NotificationEventReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.receivers = mapped
    }

    /**
     * @param argument The notification event receivers.
     */
    @JvmName("anbayqujcdpsajfi")
    public suspend fun receivers(
        vararg
        argument: suspend NotificationEventReceiverArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NotificationEventReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.receivers = mapped
    }

    /**
     * @param argument The notification event receivers.
     */
    @JvmName("lifkhphylprrvklg")
    public suspend fun receivers(argument: suspend NotificationEventReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NotificationEventReceiverArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.receivers = mapped
    }

    /**
     * @param values The notification event receivers.
     */
    @JvmName("wwtsotimelufomqa")
    public suspend fun receivers(vararg values: NotificationEventReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.receivers = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("qvxdmhxeqqujtcow")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("ncdnvgcmcbbarjyo")
    public suspend fun testBaseAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testBaseAccountName = mapped
    }

    internal fun build(): CustomerEventArgs = CustomerEventArgs(
        customerEventName = customerEventName,
        eventName = eventName,
        receivers = receivers,
        resourceGroupName = resourceGroupName,
        testBaseAccountName = testBaseAccountName,
    )
}
