@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.kotlin.outputs.PackageValidationResultResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.TargetOSInfoResponse
import com.pulumi.azurenative.testbase.kotlin.outputs.TestResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.testbase.kotlin.outputs.PackageValidationResultResponse.Companion.toKotlin as packageValidationResultResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.TargetOSInfoResponse.Companion.toKotlin as targetOSInfoResponseToKotlin
import com.pulumi.azurenative.testbase.kotlin.outputs.TestResponse.Companion.toKotlin as testResponseToKotlin

/**
 * Builder for [Package].
 */
@PulumiTagMarker
public class PackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PackageArgs = PackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PackageArgsBuilder.() -> Unit) {
        val builder = PackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Package {
        val builtJavaResource = com.pulumi.azurenative.testbase.Package(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Package(builtJavaResource)
    }
}

/**
 * The Test Base Package resource.
 * Azure REST API version: 2022-04-01-preview. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * ## Example Usage
 * ### PackageCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var package = new AzureNative.TestBase.Package("package", new()
 *     {
 *         ApplicationName = "contoso-package2",
 *         BlobPath = "storageAccountPath/package.zip",
 *         FlightingRing = "Insider Beta Channel",
 *         Location = "westus",
 *         PackageName = "contoso-package2",
 *         ResourceGroupName = "contoso-rg1",
 *         Tags = null,
 *         TargetOSList = new[]
 *         {
 *             new AzureNative.TestBase.Inputs.TargetOSInfoArgs
 *             {
 *                 OsUpdateType = "Security updates",
 *                 TargetOSs = new[]
 *                 {
 *                     "Windows 10 2004",
 *                     "Windows 10 1903",
 *                 },
 *             },
 *         },
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *         Tests = new[]
 *         {
 *             new AzureNative.TestBase.Inputs.TestArgs
 *             {
 *                 Commands = new[]
 *                 {
 *                     new AzureNative.TestBase.Inputs.CommandArgs
 *                     {
 *                         Action = "Install",
 *                         AlwaysRun = true,
 *                         ApplyUpdateBefore = false,
 *                         Content = "app/scripts/install/job.ps1",
 *                         ContentType = "Path",
 *                         MaxRunTime = 1800,
 *                         Name = "Install",
 *                         RestartAfter = true,
 *                         RunAsInteractive = true,
 *                         RunElevated = true,
 *                     },
 *                     new AzureNative.TestBase.Inputs.CommandArgs
 *                     {
 *                         Action = "Launch",
 *                         AlwaysRun = false,
 *                         ApplyUpdateBefore = true,
 *                         Content = "app/scripts/launch/job.ps1",
 *                         ContentType = "Path",
 *                         MaxRunTime = 1800,
 *                         Name = "Launch",
 *                         RestartAfter = false,
 *                         RunAsInteractive = true,
 *                         RunElevated = true,
 *                     },
 *                     new AzureNative.TestBase.Inputs.CommandArgs
 *                     {
 *                         Action = "Close",
 *                         AlwaysRun = false,
 *                         ApplyUpdateBefore = false,
 *                         Content = "app/scripts/close/job.ps1",
 *                         ContentType = "Path",
 *                         MaxRunTime = 1800,
 *                         Name = "Close",
 *                         RestartAfter = false,
 *                         RunAsInteractive = true,
 *                         RunElevated = true,
 *                     },
 *                     new AzureNative.TestBase.Inputs.CommandArgs
 *                     {
 *                         Action = "Uninstall",
 *                         AlwaysRun = true,
 *                         ApplyUpdateBefore = false,
 *                         Content = "app/scripts/uninstall/job.ps1",
 *                         ContentType = "Path",
 *                         MaxRunTime = 1800,
 *                         Name = "Uninstall",
 *                         RestartAfter = false,
 *                         RunAsInteractive = true,
 *                         RunElevated = true,
 *                     },
 *                 },
 *                 IsActive = true,
 *                 TestType = "OutOfBoxTest",
 *             },
 *         },
 *         Version = "1.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewPackage(ctx, "package", &testbase.PackageArgs{
 * 			ApplicationName:   pulumi.String("contoso-package2"),
 * 			BlobPath:          pulumi.String("storageAccountPath/package.zip"),
 * 			FlightingRing:     pulumi.String("Insider Beta Channel"),
 * 			Location:          pulumi.String("westus"),
 * 			PackageName:       pulumi.String("contoso-package2"),
 * 			ResourceGroupName: pulumi.String("contoso-rg1"),
 * 			Tags:              nil,
 * 			TargetOSList: []testbase.TargetOSInfoArgs{
 * 				{
 * 					OsUpdateType: pulumi.String("Security updates"),
 * 					TargetOSs: pulumi.StringArray{
 * 						pulumi.String("Windows 10 2004"),
 * 						pulumi.String("Windows 10 1903"),
 * 					},
 * 				},
 * 			},
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 			Tests: []testbase.TestArgs{
 * 				{
 * 					Commands: testbase.CommandArray{
 * 						{
 * 							Action:            pulumi.String("Install"),
 * 							AlwaysRun:         pulumi.Bool(true),
 * 							ApplyUpdateBefore: pulumi.Bool(false),
 * 							Content:           pulumi.String("app/scripts/install/job.ps1"),
 * 							ContentType:       pulumi.String("Path"),
 * 							MaxRunTime:        pulumi.Int(1800),
 * 							Name:              pulumi.String("Install"),
 * 							RestartAfter:      pulumi.Bool(true),
 * 							RunAsInteractive:  pulumi.Bool(true),
 * 							RunElevated:       pulumi.Bool(true),
 * 						},
 * 						{
 * 							Action:            pulumi.String("Launch"),
 * 							AlwaysRun:         pulumi.Bool(false),
 * 							ApplyUpdateBefore: pulumi.Bool(true),
 * 							Content:           pulumi.String("app/scripts/launch/job.ps1"),
 * 							ContentType:       pulumi.String("Path"),
 * 							MaxRunTime:        pulumi.Int(1800),
 * 							Name:              pulumi.String("Launch"),
 * 							RestartAfter:      pulumi.Bool(false),
 * 							RunAsInteractive:  pulumi.Bool(true),
 * 							RunElevated:       pulumi.Bool(true),
 * 						},
 * 						{
 * 							Action:            pulumi.String("Close"),
 * 							AlwaysRun:         pulumi.Bool(false),
 * 							ApplyUpdateBefore: pulumi.Bool(false),
 * 							Content:           pulumi.String("app/scripts/close/job.ps1"),
 * 							ContentType:       pulumi.String("Path"),
 * 							MaxRunTime:        pulumi.Int(1800),
 * 							Name:              pulumi.String("Close"),
 * 							RestartAfter:      pulumi.Bool(false),
 * 							RunAsInteractive:  pulumi.Bool(true),
 * 							RunElevated:       pulumi.Bool(true),
 * 						},
 * 						{
 * 							Action:            pulumi.String("Uninstall"),
 * 							AlwaysRun:         pulumi.Bool(true),
 * 							ApplyUpdateBefore: pulumi.Bool(false),
 * 							Content:           pulumi.String("app/scripts/uninstall/job.ps1"),
 * 							ContentType:       pulumi.String("Path"),
 * 							MaxRunTime:        pulumi.Int(1800),
 * 							Name:              pulumi.String("Uninstall"),
 * 							RestartAfter:      pulumi.Bool(false),
 * 							RunAsInteractive:  pulumi.Bool(true),
 * 							RunElevated:       pulumi.Bool(true),
 * 						},
 * 					},
 * 					IsActive: pulumi.Bool(true),
 * 					TestType: pulumi.String("OutOfBoxTest"),
 * 				},
 * 			},
 * 			Version: pulumi.String("1.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.Package;
 * import com.pulumi.azurenative.testbase.PackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var package_ = new Package("package", PackageArgs.builder()
 *             .applicationName("contoso-package2")
 *             .blobPath("storageAccountPath/package.zip")
 *             .flightingRing("Insider Beta Channel")
 *             .location("westus")
 *             .packageName("contoso-package2")
 *             .resourceGroupName("contoso-rg1")
 *             .tags()
 *             .targetOSList(Map.ofEntries(
 *                 Map.entry("osUpdateType", "Security updates"),
 *                 Map.entry("targetOSs",
 *                     "Windows 10 2004",
 *                     "Windows 10 1903")
 *             ))
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .tests(Map.ofEntries(
 *                 Map.entry("commands",
 *                     Map.ofEntries(
 *                         Map.entry("action", "Install"),
 *                         Map.entry("alwaysRun", true),
 *                         Map.entry("applyUpdateBefore", false),
 *                         Map.entry("content", "app/scripts/install/job.ps1"),
 *                         Map.entry("contentType", "Path"),
 *                         Map.entry("maxRunTime", 1800),
 *                         Map.entry("name", "Install"),
 *                         Map.entry("restartAfter", true),
 *                         Map.entry("runAsInteractive", true),
 *                         Map.entry("runElevated", true)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("action", "Launch"),
 *                         Map.entry("alwaysRun", false),
 *                         Map.entry("applyUpdateBefore", true),
 *                         Map.entry("content", "app/scripts/launch/job.ps1"),
 *                         Map.entry("contentType", "Path"),
 *                         Map.entry("maxRunTime", 1800),
 *                         Map.entry("name", "Launch"),
 *                         Map.entry("restartAfter", false),
 *                         Map.entry("runAsInteractive", true),
 *                         Map.entry("runElevated", true)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("action", "Close"),
 *                         Map.entry("alwaysRun", false),
 *                         Map.entry("applyUpdateBefore", false),
 *                         Map.entry("content", "app/scripts/close/job.ps1"),
 *                         Map.entry("contentType", "Path"),
 *                         Map.entry("maxRunTime", 1800),
 *                         Map.entry("name", "Close"),
 *                         Map.entry("restartAfter", false),
 *                         Map.entry("runAsInteractive", true),
 *                         Map.entry("runElevated", true)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("action", "Uninstall"),
 *                         Map.entry("alwaysRun", true),
 *                         Map.entry("applyUpdateBefore", false),
 *                         Map.entry("content", "app/scripts/uninstall/job.ps1"),
 *                         Map.entry("contentType", "Path"),
 *                         Map.entry("maxRunTime", 1800),
 *                         Map.entry("name", "Uninstall"),
 *                         Map.entry("restartAfter", false),
 *                         Map.entry("runAsInteractive", true),
 *                         Map.entry("runElevated", true)
 *                     )),
 *                 Map.entry("isActive", true),
 *                 Map.entry("testType", "OutOfBoxTest")
 *             ))
 *             .version("1.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:Package contoso-package2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}
 * ```
 */
public class Package internal constructor(
    override val javaResource: com.pulumi.azurenative.testbase.Package,
) : KotlinCustomResource(javaResource, PackageMapper) {
    /**
     * Application name
     */
    public val applicationName: Output<String>
        get() = javaResource.applicationName().applyValue({ args0 -> args0 })

    /**
     * The file path of the package.
     */
    public val blobPath: Output<String>
        get() = javaResource.blobPath().applyValue({ args0 -> args0 })

    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The flighting ring for feature update.
     */
    public val flightingRing: Output<String>
        get() = javaResource.flightingRing().applyValue({ args0 -> args0 })

    /**
     * Flag showing that whether the package is enabled. It doesn't schedule test for package which is not enabled.
     */
    public val isEnabled: Output<Boolean>
        get() = javaResource.isEnabled().applyValue({ args0 -> args0 })

    /**
     * The UTC timestamp when the package was last modified.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the package.
     */
    public val packageStatus: Output<String>
        get() = javaResource.packageStatus().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to this resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the target OSs of specific OS Update types.
     */
    public val targetOSList: Output<List<TargetOSInfoResponse>>
        get() = javaResource.targetOSList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    targetOSInfoResponseToKotlin(args0)
                })
            })
        })

    /**
     * OOB, functional or both. Mapped to the data in 'tests' property.
     */
    public val testTypes: Output<List<String>>
        get() = javaResource.testTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The detailed test information.
     */
    public val tests: Output<List<TestResponse>>
        get() = javaResource.tests().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    testResponseToKotlin(args0)
                })
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The validation results. There's validation on package when it's created or updated.
     */
    public val validationResults: Output<List<PackageValidationResultResponse>>
        get() = javaResource.validationResults().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> packageValidationResultResponseToKotlin(args0) })
            })
        })

    /**
     * Application version
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object PackageMapper : ResourceMapper<Package> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.testbase.Package::class == javaResource::class

    override fun map(javaResource: Resource): Package = Package(
        javaResource as
            com.pulumi.azurenative.testbase.Package,
    )
}

/**
 * @see [Package].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Package].
 */
public suspend fun `package`(name: String, block: suspend PackageResourceBuilder.() -> Unit):
    Package {
    val builder = PackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Package].
 * @param name The _unique_ name of the resulting resource.
 */
public fun `package`(name: String): Package {
    val builder = PackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
