@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.PackageArgs.builder
import com.pulumi.azurenative.testbase.kotlin.inputs.TargetOSInfoArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.TargetOSInfoArgsBuilder
import com.pulumi.azurenative.testbase.kotlin.inputs.TestArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.TestArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Test Base Package resource.
 * Azure REST API version: 2022-04-01-preview. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * ## Example Usage
 * ### PackageCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var package = new AzureNative.TestBase.Package("package", new()
 *     {
 *         ApplicationName = "contoso-package2",
 *         BlobPath = "storageAccountPath/package.zip",
 *         FlightingRing = "Insider Beta Channel",
 *         Location = "westus",
 *         PackageName = "contoso-package2",
 *         ResourceGroupName = "contoso-rg1",
 *         Tags = null,
 *         TargetOSList = new[]
 *         {
 *             new AzureNative.TestBase.Inputs.TargetOSInfoArgs
 *             {
 *                 OsUpdateType = "Security updates",
 *                 TargetOSs = new[]
 *                 {
 *                     "Windows 10 2004",
 *                     "Windows 10 1903",
 *                 },
 *             },
 *         },
 *         TestBaseAccountName = "contoso-testBaseAccount1",
 *         Tests = new[]
 *         {
 *             new AzureNative.TestBase.Inputs.TestArgs
 *             {
 *                 Commands = new[]
 *                 {
 *                     new AzureNative.TestBase.Inputs.CommandArgs
 *                     {
 *                         Action = "Install",
 *                         AlwaysRun = true,
 *                         ApplyUpdateBefore = false,
 *                         Content = "app/scripts/install/job.ps1",
 *                         ContentType = "Path",
 *                         MaxRunTime = 1800,
 *                         Name = "Install",
 *                         RestartAfter = true,
 *                         RunAsInteractive = true,
 *                         RunElevated = true,
 *                     },
 *                     new AzureNative.TestBase.Inputs.CommandArgs
 *                     {
 *                         Action = "Launch",
 *                         AlwaysRun = false,
 *                         ApplyUpdateBefore = true,
 *                         Content = "app/scripts/launch/job.ps1",
 *                         ContentType = "Path",
 *                         MaxRunTime = 1800,
 *                         Name = "Launch",
 *                         RestartAfter = false,
 *                         RunAsInteractive = true,
 *                         RunElevated = true,
 *                     },
 *                     new AzureNative.TestBase.Inputs.CommandArgs
 *                     {
 *                         Action = "Close",
 *                         AlwaysRun = false,
 *                         ApplyUpdateBefore = false,
 *                         Content = "app/scripts/close/job.ps1",
 *                         ContentType = "Path",
 *                         MaxRunTime = 1800,
 *                         Name = "Close",
 *                         RestartAfter = false,
 *                         RunAsInteractive = true,
 *                         RunElevated = true,
 *                     },
 *                     new AzureNative.TestBase.Inputs.CommandArgs
 *                     {
 *                         Action = "Uninstall",
 *                         AlwaysRun = true,
 *                         ApplyUpdateBefore = false,
 *                         Content = "app/scripts/uninstall/job.ps1",
 *                         ContentType = "Path",
 *                         MaxRunTime = 1800,
 *                         Name = "Uninstall",
 *                         RestartAfter = false,
 *                         RunAsInteractive = true,
 *                         RunElevated = true,
 *                     },
 *                 },
 *                 IsActive = true,
 *                 TestType = "OutOfBoxTest",
 *             },
 *         },
 *         Version = "1.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewPackage(ctx, "package", &testbase.PackageArgs{
 * 			ApplicationName:   pulumi.String("contoso-package2"),
 * 			BlobPath:          pulumi.String("storageAccountPath/package.zip"),
 * 			FlightingRing:     pulumi.String("Insider Beta Channel"),
 * 			Location:          pulumi.String("westus"),
 * 			PackageName:       pulumi.String("contoso-package2"),
 * 			ResourceGroupName: pulumi.String("contoso-rg1"),
 * 			Tags:              nil,
 * 			TargetOSList: []testbase.TargetOSInfoArgs{
 * 				{
 * 					OsUpdateType: pulumi.String("Security updates"),
 * 					TargetOSs: pulumi.StringArray{
 * 						pulumi.String("Windows 10 2004"),
 * 						pulumi.String("Windows 10 1903"),
 * 					},
 * 				},
 * 			},
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount1"),
 * 			Tests: []testbase.TestArgs{
 * 				{
 * 					Commands: testbase.CommandArray{
 * 						{
 * 							Action:            pulumi.String("Install"),
 * 							AlwaysRun:         pulumi.Bool(true),
 * 							ApplyUpdateBefore: pulumi.Bool(false),
 * 							Content:           pulumi.String("app/scripts/install/job.ps1"),
 * 							ContentType:       pulumi.String("Path"),
 * 							MaxRunTime:        pulumi.Int(1800),
 * 							Name:              pulumi.String("Install"),
 * 							RestartAfter:      pulumi.Bool(true),
 * 							RunAsInteractive:  pulumi.Bool(true),
 * 							RunElevated:       pulumi.Bool(true),
 * 						},
 * 						{
 * 							Action:            pulumi.String("Launch"),
 * 							AlwaysRun:         pulumi.Bool(false),
 * 							ApplyUpdateBefore: pulumi.Bool(true),
 * 							Content:           pulumi.String("app/scripts/launch/job.ps1"),
 * 							ContentType:       pulumi.String("Path"),
 * 							MaxRunTime:        pulumi.Int(1800),
 * 							Name:              pulumi.String("Launch"),
 * 							RestartAfter:      pulumi.Bool(false),
 * 							RunAsInteractive:  pulumi.Bool(true),
 * 							RunElevated:       pulumi.Bool(true),
 * 						},
 * 						{
 * 							Action:            pulumi.String("Close"),
 * 							AlwaysRun:         pulumi.Bool(false),
 * 							ApplyUpdateBefore: pulumi.Bool(false),
 * 							Content:           pulumi.String("app/scripts/close/job.ps1"),
 * 							ContentType:       pulumi.String("Path"),
 * 							MaxRunTime:        pulumi.Int(1800),
 * 							Name:              pulumi.String("Close"),
 * 							RestartAfter:      pulumi.Bool(false),
 * 							RunAsInteractive:  pulumi.Bool(true),
 * 							RunElevated:       pulumi.Bool(true),
 * 						},
 * 						{
 * 							Action:            pulumi.String("Uninstall"),
 * 							AlwaysRun:         pulumi.Bool(true),
 * 							ApplyUpdateBefore: pulumi.Bool(false),
 * 							Content:           pulumi.String("app/scripts/uninstall/job.ps1"),
 * 							ContentType:       pulumi.String("Path"),
 * 							MaxRunTime:        pulumi.Int(1800),
 * 							Name:              pulumi.String("Uninstall"),
 * 							RestartAfter:      pulumi.Bool(false),
 * 							RunAsInteractive:  pulumi.Bool(true),
 * 							RunElevated:       pulumi.Bool(true),
 * 						},
 * 					},
 * 					IsActive: pulumi.Bool(true),
 * 					TestType: pulumi.String("OutOfBoxTest"),
 * 				},
 * 			},
 * 			Version: pulumi.String("1.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.Package;
 * import com.pulumi.azurenative.testbase.PackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var package_ = new Package("package", PackageArgs.builder()
 *             .applicationName("contoso-package2")
 *             .blobPath("storageAccountPath/package.zip")
 *             .flightingRing("Insider Beta Channel")
 *             .location("westus")
 *             .packageName("contoso-package2")
 *             .resourceGroupName("contoso-rg1")
 *             .tags()
 *             .targetOSList(Map.ofEntries(
 *                 Map.entry("osUpdateType", "Security updates"),
 *                 Map.entry("targetOSs",
 *                     "Windows 10 2004",
 *                     "Windows 10 1903")
 *             ))
 *             .testBaseAccountName("contoso-testBaseAccount1")
 *             .tests(Map.ofEntries(
 *                 Map.entry("commands",
 *                     Map.ofEntries(
 *                         Map.entry("action", "Install"),
 *                         Map.entry("alwaysRun", true),
 *                         Map.entry("applyUpdateBefore", false),
 *                         Map.entry("content", "app/scripts/install/job.ps1"),
 *                         Map.entry("contentType", "Path"),
 *                         Map.entry("maxRunTime", 1800),
 *                         Map.entry("name", "Install"),
 *                         Map.entry("restartAfter", true),
 *                         Map.entry("runAsInteractive", true),
 *                         Map.entry("runElevated", true)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("action", "Launch"),
 *                         Map.entry("alwaysRun", false),
 *                         Map.entry("applyUpdateBefore", true),
 *                         Map.entry("content", "app/scripts/launch/job.ps1"),
 *                         Map.entry("contentType", "Path"),
 *                         Map.entry("maxRunTime", 1800),
 *                         Map.entry("name", "Launch"),
 *                         Map.entry("restartAfter", false),
 *                         Map.entry("runAsInteractive", true),
 *                         Map.entry("runElevated", true)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("action", "Close"),
 *                         Map.entry("alwaysRun", false),
 *                         Map.entry("applyUpdateBefore", false),
 *                         Map.entry("content", "app/scripts/close/job.ps1"),
 *                         Map.entry("contentType", "Path"),
 *                         Map.entry("maxRunTime", 1800),
 *                         Map.entry("name", "Close"),
 *                         Map.entry("restartAfter", false),
 *                         Map.entry("runAsInteractive", true),
 *                         Map.entry("runElevated", true)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("action", "Uninstall"),
 *                         Map.entry("alwaysRun", true),
 *                         Map.entry("applyUpdateBefore", false),
 *                         Map.entry("content", "app/scripts/uninstall/job.ps1"),
 *                         Map.entry("contentType", "Path"),
 *                         Map.entry("maxRunTime", 1800),
 *                         Map.entry("name", "Uninstall"),
 *                         Map.entry("restartAfter", false),
 *                         Map.entry("runAsInteractive", true),
 *                         Map.entry("runElevated", true)
 *                     )),
 *                 Map.entry("isActive", true),
 *                 Map.entry("testType", "OutOfBoxTest")
 *             ))
 *             .version("1.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:Package contoso-package2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}
 * ```
 * @property applicationName Application name
 * @property blobPath The file path of the package.
 * @property flightingRing The flighting ring for feature update.
 * @property location The geo-location where the resource lives
 * @property packageName The resource name of the Test Base Package.
 * @property resourceGroupName The name of the resource group that contains the resource.
 * @property tags The tags of the resource.
 * @property targetOSList Specifies the target OSs of specific OS Update types.
 * @property testBaseAccountName The resource name of the Test Base Account.
 * @property tests The detailed test information.
 * @property version Application version
 */
public data class PackageArgs(
    public val applicationName: Output<String>? = null,
    public val blobPath: Output<String>? = null,
    public val flightingRing: Output<String>? = null,
    public val location: Output<String>? = null,
    public val packageName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetOSList: Output<List<TargetOSInfoArgs>>? = null,
    public val testBaseAccountName: Output<String>? = null,
    public val tests: Output<List<TestArgs>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.PackageArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.PackageArgs =
        com.pulumi.azurenative.testbase.PackageArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .blobPath(blobPath?.applyValue({ args0 -> args0 }))
            .flightingRing(flightingRing?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetOSList(
                targetOSList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .testBaseAccountName(testBaseAccountName?.applyValue({ args0 -> args0 }))
            .tests(tests?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PackageArgs].
 */
@PulumiTagMarker
public class PackageArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var blobPath: Output<String>? = null

    private var flightingRing: Output<String>? = null

    private var location: Output<String>? = null

    private var packageName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetOSList: Output<List<TargetOSInfoArgs>>? = null

    private var testBaseAccountName: Output<String>? = null

    private var tests: Output<List<TestArgs>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Application name
     */
    @JvmName("kncpisykrxlovadb")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The file path of the package.
     */
    @JvmName("mppskqrgwglfmxqn")
    public suspend fun blobPath(`value`: Output<String>) {
        this.blobPath = value
    }

    /**
     * @param value The flighting ring for feature update.
     */
    @JvmName("eripaxuxxacmnotj")
    public suspend fun flightingRing(`value`: Output<String>) {
        this.flightingRing = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ldqaabilonnqudfm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource name of the Test Base Package.
     */
    @JvmName("tykoyshqadschoic")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("yfguyvumcguyxoch")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("vsqngoletxvphrbn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the target OSs of specific OS Update types.
     */
    @JvmName("alpatdvceviekfbw")
    public suspend fun targetOSList(`value`: Output<List<TargetOSInfoArgs>>) {
        this.targetOSList = value
    }

    @JvmName("wgroxuqxlvntqtsd")
    public suspend fun targetOSList(vararg values: Output<TargetOSInfoArgs>) {
        this.targetOSList = Output.all(values.asList())
    }

    /**
     * @param values Specifies the target OSs of specific OS Update types.
     */
    @JvmName("ctotiusitnqioyiy")
    public suspend fun targetOSList(values: List<Output<TargetOSInfoArgs>>) {
        this.targetOSList = Output.all(values)
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("wygwbhherejqlsgt")
    public suspend fun testBaseAccountName(`value`: Output<String>) {
        this.testBaseAccountName = value
    }

    /**
     * @param value The detailed test information.
     */
    @JvmName("tiweygdncxvpbnpl")
    public suspend fun tests(`value`: Output<List<TestArgs>>) {
        this.tests = value
    }

    @JvmName("drtegmdgihjpbcef")
    public suspend fun tests(vararg values: Output<TestArgs>) {
        this.tests = Output.all(values.asList())
    }

    /**
     * @param values The detailed test information.
     */
    @JvmName("akfegpelvlakrbcp")
    public suspend fun tests(values: List<Output<TestArgs>>) {
        this.tests = Output.all(values)
    }

    /**
     * @param value Application version
     */
    @JvmName("kdwpbovayxtiiirg")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Application name
     */
    @JvmName("rikcnbncxtfjdebv")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The file path of the package.
     */
    @JvmName("dihwrohjddcwctve")
    public suspend fun blobPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobPath = mapped
    }

    /**
     * @param value The flighting ring for feature update.
     */
    @JvmName("mfwnvowakpbqhdfr")
    public suspend fun flightingRing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flightingRing = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ganmcvgtjgciphku")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource name of the Test Base Package.
     */
    @JvmName("rmmoxciolmbmvspx")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("lxltfkkdgaftittx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("ioporatcmjulnram")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("xqknylyrbpnxdsdi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the target OSs of specific OS Update types.
     */
    @JvmName("fbjsrybwlmxgplqw")
    public suspend fun targetOSList(`value`: List<TargetOSInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetOSList = mapped
    }

    /**
     * @param argument Specifies the target OSs of specific OS Update types.
     */
    @JvmName("yoofknnrigycnwca")
    public suspend fun targetOSList(argument: List<suspend TargetOSInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetOSInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetOSList = mapped
    }

    /**
     * @param argument Specifies the target OSs of specific OS Update types.
     */
    @JvmName("imuccswwsguntwiq")
    public suspend fun targetOSList(vararg argument: suspend TargetOSInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TargetOSInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetOSList = mapped
    }

    /**
     * @param argument Specifies the target OSs of specific OS Update types.
     */
    @JvmName("tqchmildskotvbig")
    public suspend fun targetOSList(argument: suspend TargetOSInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TargetOSInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targetOSList = mapped
    }

    /**
     * @param values Specifies the target OSs of specific OS Update types.
     */
    @JvmName("eliiunwttmxabikf")
    public suspend fun targetOSList(vararg values: TargetOSInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetOSList = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("vtjytljapojsogaw")
    public suspend fun testBaseAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testBaseAccountName = mapped
    }

    /**
     * @param value The detailed test information.
     */
    @JvmName("ijabrinbxiitsrli")
    public suspend fun tests(`value`: List<TestArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tests = mapped
    }

    /**
     * @param argument The detailed test information.
     */
    @JvmName("ssbuiphunfyaggep")
    public suspend fun tests(argument: List<suspend TestArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TestArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tests = mapped
    }

    /**
     * @param argument The detailed test information.
     */
    @JvmName("rxucutndyjspyvwe")
    public suspend fun tests(vararg argument: suspend TestArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TestArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tests = mapped
    }

    /**
     * @param argument The detailed test information.
     */
    @JvmName("cenadtrfwowdjbgo")
    public suspend fun tests(argument: suspend TestArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TestArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tests = mapped
    }

    /**
     * @param values The detailed test information.
     */
    @JvmName("qsaguhoqttldinwj")
    public suspend fun tests(vararg values: TestArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tests = mapped
    }

    /**
     * @param value Application version
     */
    @JvmName("bsnnxokywumjslso")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): PackageArgs = PackageArgs(
        applicationName = applicationName,
        blobPath = blobPath,
        flightingRing = flightingRing,
        location = location,
        packageName = packageName,
        resourceGroupName = resourceGroupName,
        tags = tags,
        targetOSList = targetOSList,
        testBaseAccountName = testBaseAccountName,
        tests = tests,
        version = version,
    )
}
