@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.GetBillingHubServiceUsagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endTimeStamp
 * @property pageIndex
 * @property pageSize
 * @property resourceGroupName The name of the resource group that contains the resource.
 * @property startTimeStamp
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class GetBillingHubServiceUsagePlainArgs(
    public val endTimeStamp: String,
    public val pageIndex: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupName: String,
    public val startTimeStamp: String,
    public val testBaseAccountName: String,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.GetBillingHubServiceUsagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.GetBillingHubServiceUsagePlainArgs =
        com.pulumi.azurenative.testbase.inputs.GetBillingHubServiceUsagePlainArgs.builder()
            .endTimeStamp(endTimeStamp.let({ args0 -> args0 }))
            .pageIndex(pageIndex?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .startTimeStamp(startTimeStamp.let({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBillingHubServiceUsagePlainArgs].
 */
@PulumiTagMarker
public class GetBillingHubServiceUsagePlainArgsBuilder internal constructor() {
    private var endTimeStamp: String? = null

    private var pageIndex: Int? = null

    private var pageSize: Int? = null

    private var resourceGroupName: String? = null

    private var startTimeStamp: String? = null

    private var testBaseAccountName: String? = null

    /**
     * @param value
     */
    @JvmName("xcnhpvmtvnqrwkbb")
    public suspend fun endTimeStamp(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endTimeStamp = mapped
    }

    /**
     * @param value
     */
    @JvmName("ghkacpyxdmxaowuq")
    public suspend fun pageIndex(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageIndex = mapped
    }

    /**
     * @param value
     */
    @JvmName("pgchyvoeysbqjitg")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("shqqjienuosmmjue")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("nduobrirwfaydeek")
    public suspend fun startTimeStamp(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.startTimeStamp = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("cflosivokqypaktw")
    public suspend fun testBaseAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.testBaseAccountName = mapped
    }

    internal fun build(): GetBillingHubServiceUsagePlainArgs = GetBillingHubServiceUsagePlainArgs(
        endTimeStamp = endTimeStamp ?: throw PulumiNullFieldException("endTimeStamp"),
        pageIndex = pageIndex,
        pageSize = pageSize,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        startTimeStamp = startTimeStamp ?: throw PulumiNullFieldException("startTimeStamp"),
        testBaseAccountName = testBaseAccountName ?: throw PulumiNullFieldException("testBaseAccountName"),
    )
}
