@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.TargetOSInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The information of the target OS to be tested.
 * @property baselineOSs Specifies the baseline OSs to be tested.
 * @property osUpdateType Specifies the OS update type to test against, e.g., 'Security updates' or 'Feature updates'.
 * @property targetOSs Specifies the target OSs to be tested.
 */
public data class TargetOSInfoArgs(
    public val baselineOSs: Output<List<String>>? = null,
    public val osUpdateType: Output<String>,
    public val targetOSs: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.TargetOSInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.TargetOSInfoArgs =
        com.pulumi.azurenative.testbase.inputs.TargetOSInfoArgs.builder()
            .baselineOSs(baselineOSs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .osUpdateType(osUpdateType.applyValue({ args0 -> args0 }))
            .targetOSs(targetOSs.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TargetOSInfoArgs].
 */
@PulumiTagMarker
public class TargetOSInfoArgsBuilder internal constructor() {
    private var baselineOSs: Output<List<String>>? = null

    private var osUpdateType: Output<String>? = null

    private var targetOSs: Output<List<String>>? = null

    /**
     * @param value Specifies the baseline OSs to be tested.
     */
    @JvmName("qucrlpmlmqyqhynb")
    public suspend fun baselineOSs(`value`: Output<List<String>>) {
        this.baselineOSs = value
    }

    @JvmName("ecxlhxrqmbgnxoyd")
    public suspend fun baselineOSs(vararg values: Output<String>) {
        this.baselineOSs = Output.all(values.asList())
    }

    /**
     * @param values Specifies the baseline OSs to be tested.
     */
    @JvmName("nrhlkfsibmkkfare")
    public suspend fun baselineOSs(values: List<Output<String>>) {
        this.baselineOSs = Output.all(values)
    }

    /**
     * @param value Specifies the OS update type to test against, e.g., 'Security updates' or 'Feature updates'.
     */
    @JvmName("gwukgnysrtukekbb")
    public suspend fun osUpdateType(`value`: Output<String>) {
        this.osUpdateType = value
    }

    /**
     * @param value Specifies the target OSs to be tested.
     */
    @JvmName("iexfuquoveyktrvq")
    public suspend fun targetOSs(`value`: Output<List<String>>) {
        this.targetOSs = value
    }

    @JvmName("duuhoflsdfabouwn")
    public suspend fun targetOSs(vararg values: Output<String>) {
        this.targetOSs = Output.all(values.asList())
    }

    /**
     * @param values Specifies the target OSs to be tested.
     */
    @JvmName("yscndvguphqyhmhj")
    public suspend fun targetOSs(values: List<Output<String>>) {
        this.targetOSs = Output.all(values)
    }

    /**
     * @param value Specifies the baseline OSs to be tested.
     */
    @JvmName("fnwmarrfbqyuijdb")
    public suspend fun baselineOSs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineOSs = mapped
    }

    /**
     * @param values Specifies the baseline OSs to be tested.
     */
    @JvmName("maubrqkvwtdqrkfj")
    public suspend fun baselineOSs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baselineOSs = mapped
    }

    /**
     * @param value Specifies the OS update type to test against, e.g., 'Security updates' or 'Feature updates'.
     */
    @JvmName("qfuaytpysemyljgp")
    public suspend fun osUpdateType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osUpdateType = mapped
    }

    /**
     * @param value Specifies the target OSs to be tested.
     */
    @JvmName("touubolqsjccevey")
    public suspend fun targetOSs(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetOSs = mapped
    }

    /**
     * @param values Specifies the target OSs to be tested.
     */
    @JvmName("nqaxutsjpipwtnwa")
    public suspend fun targetOSs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetOSs = mapped
    }

    internal fun build(): TargetOSInfoArgs = TargetOSInfoArgs(
        baselineOSs = baselineOSs,
        osUpdateType = osUpdateType ?: throw PulumiNullFieldException("osUpdateType"),
        targetOSs = targetOSs ?: throw PulumiNullFieldException("targetOSs"),
    )
}
