@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.TestBaseAccountSKUArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.Tier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a Test Base Account SKU.
 * @property locations The locations that the SKU is available.
 * @property name The name of the SKU. This is typically a letter + number code, such as B0 or S0.
 * @property resourceType The type of resource the SKU applies to.
 * @property tier The tier of this particular SKU.
 */
public data class TestBaseAccountSKUArgs(
    public val locations: Output<List<String>>? = null,
    public val name: Output<String>,
    public val resourceType: Output<String>? = null,
    public val tier: Output<Either<String, Tier>>,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.TestBaseAccountSKUArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.TestBaseAccountSKUArgs =
        com.pulumi.azurenative.testbase.inputs.TestBaseAccountSKUArgs.builder()
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .tier(
                tier.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TestBaseAccountSKUArgs].
 */
@PulumiTagMarker
public class TestBaseAccountSKUArgsBuilder internal constructor() {
    private var locations: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var tier: Output<Either<String, Tier>>? = null

    /**
     * @param value The locations that the SKU is available.
     */
    @JvmName("kowmnsdbbxxdbgbx")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("odtdcclvbytcabub")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values The locations that the SKU is available.
     */
    @JvmName("drkrkppibxycrogn")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value The name of the SKU. This is typically a letter + number code, such as B0 or S0.
     */
    @JvmName("cttatpouslmfaeib")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of resource the SKU applies to.
     */
    @JvmName("cndueocbpfvqqfrx")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The tier of this particular SKU.
     */
    @JvmName("oohfoclwkjlaagyl")
    public suspend fun tier(`value`: Output<Either<String, Tier>>) {
        this.tier = value
    }

    /**
     * @param value The locations that the SKU is available.
     */
    @JvmName("hqlfqcycncegvubw")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values The locations that the SKU is available.
     */
    @JvmName("owclvsowjexlrwlr")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value The name of the SKU. This is typically a letter + number code, such as B0 or S0.
     */
    @JvmName("clauqqmvfulggvtg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of resource the SKU applies to.
     */
    @JvmName("jsthupjhbewdhcrk")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The tier of this particular SKU.
     */
    @JvmName("pktsdwgktqmmdsbn")
    public suspend fun tier(`value`: Either<String, Tier>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The tier of this particular SKU.
     */
    @JvmName("qgxrhprslgpjddna")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Tier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The tier of this particular SKU.
     */
    @JvmName("cwvxoppgamsdtnqg")
    public fun tier(`value`: Tier) {
        val toBeMapped = Either.ofRight<String, Tier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): TestBaseAccountSKUArgs = TestBaseAccountSKUArgs(
        locations = locations,
        name = name ?: throw PulumiNullFieldException("name"),
        resourceType = resourceType,
        tier = tier ?: throw PulumiNullFieldException("tier"),
    )
}
