@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.UserObjectReceiverValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The user object receiver value.
 * @property userObjectIds user object ids.
 */
public data class UserObjectReceiverValueArgs(
    public val userObjectIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.UserObjectReceiverValueArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.UserObjectReceiverValueArgs =
        com.pulumi.azurenative.testbase.inputs.UserObjectReceiverValueArgs.builder()
            .userObjectIds(userObjectIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [UserObjectReceiverValueArgs].
 */
@PulumiTagMarker
public class UserObjectReceiverValueArgsBuilder internal constructor() {
    private var userObjectIds: Output<List<String>>? = null

    /**
     * @param value user object ids.
     */
    @JvmName("njiylruhbvlpmkyd")
    public suspend fun userObjectIds(`value`: Output<List<String>>) {
        this.userObjectIds = value
    }

    @JvmName("jqrjxgkqejvaylbu")
    public suspend fun userObjectIds(vararg values: Output<String>) {
        this.userObjectIds = Output.all(values.asList())
    }

    /**
     * @param values user object ids.
     */
    @JvmName("dgafburboeklxkwv")
    public suspend fun userObjectIds(values: List<Output<String>>) {
        this.userObjectIds = Output.all(values)
    }

    /**
     * @param value user object ids.
     */
    @JvmName("aahngjtaudvugihr")
    public suspend fun userObjectIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userObjectIds = mapped
    }

    /**
     * @param values user object ids.
     */
    @JvmName("hrawwcrhfmdalrve")
    public suspend fun userObjectIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userObjectIds = mapped
    }

    internal fun build(): UserObjectReceiverValueArgs = UserObjectReceiverValueArgs(
        userObjectIds = userObjectIds,
    )
}
