@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The command used in the test
 * @property action The action of the command.
 * @property alwaysRun Specifies whether to run the command even if a previous command is failed.
 * @property applyUpdateBefore Specifies whether to apply update before the command.
 * @property content The content of the command. The content depends on source type.
 * @property contentType The type of command content.
 * @property maxRunTime Specifies the max run time of the command.
 * @property name The name of the command.
 * @property restartAfter Specifies whether to restart the VM after the command executed.
 * @property runAsInteractive Specifies whether to run the command in interactive mode.
 * @property runElevated Specifies whether to run the command as administrator.
 */
public data class CommandResponse(
    public val action: String,
    public val alwaysRun: Boolean? = null,
    public val applyUpdateBefore: Boolean? = null,
    public val content: String,
    public val contentType: String,
    public val maxRunTime: Int? = null,
    public val name: String,
    public val restartAfter: Boolean? = null,
    public val runAsInteractive: Boolean? = null,
    public val runElevated: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.CommandResponse):
            CommandResponse = CommandResponse(
            action = javaType.action(),
            alwaysRun = javaType.alwaysRun().map({ args0 -> args0 }).orElse(null),
            applyUpdateBefore = javaType.applyUpdateBefore().map({ args0 -> args0 }).orElse(null),
            content = javaType.content(),
            contentType = javaType.contentType(),
            maxRunTime = javaType.maxRunTime().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            restartAfter = javaType.restartAfter().map({ args0 -> args0 }).orElse(null),
            runAsInteractive = javaType.runAsInteractive().map({ args0 -> args0 }).orElse(null),
            runElevated = javaType.runElevated().map({ args0 -> args0 }).orElse(null),
        )
    }
}
