@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.TimeseriesinsightsFunctions.getAccessPolicyPlain
import com.pulumi.azurenative.timeseriesinsights.TimeseriesinsightsFunctions.getEventHubEventSourcePlain
import com.pulumi.azurenative.timeseriesinsights.TimeseriesinsightsFunctions.getGen1EnvironmentPlain
import com.pulumi.azurenative.timeseriesinsights.TimeseriesinsightsFunctions.getGen2EnvironmentPlain
import com.pulumi.azurenative.timeseriesinsights.TimeseriesinsightsFunctions.getIoTHubEventSourcePlain
import com.pulumi.azurenative.timeseriesinsights.TimeseriesinsightsFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.timeseriesinsights.TimeseriesinsightsFunctions.getReferenceDataSetPlain
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetAccessPolicyPlainArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetAccessPolicyPlainArgsBuilder
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetEventHubEventSourcePlainArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetEventHubEventSourcePlainArgsBuilder
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetGen1EnvironmentPlainArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetGen1EnvironmentPlainArgsBuilder
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetGen2EnvironmentPlainArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetGen2EnvironmentPlainArgsBuilder
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetIoTHubEventSourcePlainArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetIoTHubEventSourcePlainArgsBuilder
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetReferenceDataSetPlainArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.GetReferenceDataSetPlainArgsBuilder
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetAccessPolicyResult
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetEventHubEventSourceResult
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetGen1EnvironmentResult
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetGen2EnvironmentResult
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetIoTHubEventSourceResult
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetReferenceDataSetResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetAccessPolicyResult.Companion.toKotlin as getAccessPolicyResultToKotlin
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetEventHubEventSourceResult.Companion.toKotlin as getEventHubEventSourceResultToKotlin
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetGen1EnvironmentResult.Companion.toKotlin as getGen1EnvironmentResultToKotlin
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetGen2EnvironmentResult.Companion.toKotlin as getGen2EnvironmentResultToKotlin
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetIoTHubEventSourceResult.Companion.toKotlin as getIoTHubEventSourceResultToKotlin
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.GetReferenceDataSetResult.Companion.toKotlin as getReferenceDataSetResultToKotlin

public object TimeseriesinsightsFunctions {
    /**
     * Gets the access policy with the specified name in the specified environment.
     * Azure REST API version: 2020-05-15.
     * Other available API versions: 2017-11-15, 2021-06-30-preview.
     * @param argument null
     * @return An access policy is used to grant users and applications access to the environment. Roles are assigned to service principals in Azure Active Directory. These roles define the actions the principal can perform through the Time Series Insights data plane APIs.
     */
    public suspend fun getAccessPolicy(argument: GetAccessPolicyPlainArgs): GetAccessPolicyResult =
        getAccessPolicyResultToKotlin(getAccessPolicyPlain(argument.toJava()).await())

    /**
     * @see [getAccessPolicy].
     * @param accessPolicyName The name of the Time Series Insights access policy associated with the specified environment.
     * @param environmentName The name of the Time Series Insights environment associated with the specified resource group.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return An access policy is used to grant users and applications access to the environment. Roles are assigned to service principals in Azure Active Directory. These roles define the actions the principal can perform through the Time Series Insights data plane APIs.
     */
    public suspend fun getAccessPolicy(
        accessPolicyName: String,
        environmentName: String,
        resourceGroupName: String,
    ): GetAccessPolicyResult {
        val argument = GetAccessPolicyPlainArgs(
            accessPolicyName = accessPolicyName,
            environmentName = environmentName,
            resourceGroupName = resourceGroupName,
        )
        return getAccessPolicyResultToKotlin(getAccessPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;timeseriesinsights&#46;kotlin&#46;inputs&#46;GetAccessPolicyPlainArgs].
     * @return An access policy is used to grant users and applications access to the environment. Roles are assigned to service principals in Azure Active Directory. These roles define the actions the principal can perform through the Time Series Insights data plane APIs.
     */
    public suspend fun getAccessPolicy(argument: suspend GetAccessPolicyPlainArgsBuilder.() -> Unit):
        GetAccessPolicyResult {
        val builder = GetAccessPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessPolicyResultToKotlin(getAccessPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the event source with the specified name in the specified environment.
     * Azure REST API version: 2020-05-15.
     * @param argument null
     * @return An event source that receives its data from an Azure EventHub.
     */
    public suspend fun getEventHubEventSource(argument: GetEventHubEventSourcePlainArgs):
        GetEventHubEventSourceResult =
        getEventHubEventSourceResultToKotlin(getEventHubEventSourcePlain(argument.toJava()).await())

    /**
     * @see [getEventHubEventSource].
     * @param environmentName The name of the Time Series Insights environment associated with the specified resource group.
     * @param eventSourceName The name of the Time Series Insights event source associated with the specified environment.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return An event source that receives its data from an Azure EventHub.
     */
    public suspend fun getEventHubEventSource(
        environmentName: String,
        eventSourceName: String,
        resourceGroupName: String,
    ): GetEventHubEventSourceResult {
        val argument = GetEventHubEventSourcePlainArgs(
            environmentName = environmentName,
            eventSourceName = eventSourceName,
            resourceGroupName = resourceGroupName,
        )
        return getEventHubEventSourceResultToKotlin(getEventHubEventSourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getEventHubEventSource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;timeseriesinsights&#46;kotlin&#46;inputs&#46;GetEventHubEventSourcePlainArgs].
     * @return An event source that receives its data from an Azure EventHub.
     */
    public suspend
    fun getEventHubEventSource(argument: suspend GetEventHubEventSourcePlainArgsBuilder.() -> Unit):
        GetEventHubEventSourceResult {
        val builder = GetEventHubEventSourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventHubEventSourceResultToKotlin(getEventHubEventSourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the environment with the specified name in the specified subscription and resource group.
     * Azure REST API version: 2020-05-15.
     * @param argument null
     * @return An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen1 environments have data retention limits.
     */
    public suspend fun getGen1Environment(argument: GetGen1EnvironmentPlainArgs):
        GetGen1EnvironmentResult =
        getGen1EnvironmentResultToKotlin(getGen1EnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getGen1Environment].
     * @param environmentName The name of the Time Series Insights environment associated with the specified resource group.
     * @param expand Setting $expand=status will include the status of the internal services of the environment in the Time Series Insights service.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen1 environments have data retention limits.
     */
    public suspend fun getGen1Environment(
        environmentName: String,
        expand: String? = null,
        resourceGroupName: String,
    ): GetGen1EnvironmentResult {
        val argument = GetGen1EnvironmentPlainArgs(
            environmentName = environmentName,
            expand = expand,
            resourceGroupName = resourceGroupName,
        )
        return getGen1EnvironmentResultToKotlin(getGen1EnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getGen1Environment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;timeseriesinsights&#46;kotlin&#46;inputs&#46;GetGen1EnvironmentPlainArgs].
     * @return An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen1 environments have data retention limits.
     */
    public suspend
    fun getGen1Environment(argument: suspend GetGen1EnvironmentPlainArgsBuilder.() -> Unit):
        GetGen1EnvironmentResult {
        val builder = GetGen1EnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGen1EnvironmentResultToKotlin(getGen1EnvironmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the environment with the specified name in the specified subscription and resource group.
     * Azure REST API version: 2020-05-15.
     * @param argument null
     * @return An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen2 environments do not have set data retention limits.
     */
    public suspend fun getGen2Environment(argument: GetGen2EnvironmentPlainArgs):
        GetGen2EnvironmentResult =
        getGen2EnvironmentResultToKotlin(getGen2EnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getGen2Environment].
     * @param environmentName The name of the Time Series Insights environment associated with the specified resource group.
     * @param expand Setting $expand=status will include the status of the internal services of the environment in the Time Series Insights service.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen2 environments do not have set data retention limits.
     */
    public suspend fun getGen2Environment(
        environmentName: String,
        expand: String? = null,
        resourceGroupName: String,
    ): GetGen2EnvironmentResult {
        val argument = GetGen2EnvironmentPlainArgs(
            environmentName = environmentName,
            expand = expand,
            resourceGroupName = resourceGroupName,
        )
        return getGen2EnvironmentResultToKotlin(getGen2EnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getGen2Environment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;timeseriesinsights&#46;kotlin&#46;inputs&#46;GetGen2EnvironmentPlainArgs].
     * @return An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource. Gen2 environments do not have set data retention limits.
     */
    public suspend
    fun getGen2Environment(argument: suspend GetGen2EnvironmentPlainArgsBuilder.() -> Unit):
        GetGen2EnvironmentResult {
        val builder = GetGen2EnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGen2EnvironmentResultToKotlin(getGen2EnvironmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the event source with the specified name in the specified environment.
     * Azure REST API version: 2020-05-15.
     * @param argument null
     * @return An event source that receives its data from an Azure IoTHub.
     */
    public suspend fun getIoTHubEventSource(argument: GetIoTHubEventSourcePlainArgs):
        GetIoTHubEventSourceResult =
        getIoTHubEventSourceResultToKotlin(getIoTHubEventSourcePlain(argument.toJava()).await())

    /**
     * @see [getIoTHubEventSource].
     * @param environmentName The name of the Time Series Insights environment associated with the specified resource group.
     * @param eventSourceName The name of the Time Series Insights event source associated with the specified environment.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return An event source that receives its data from an Azure IoTHub.
     */
    public suspend fun getIoTHubEventSource(
        environmentName: String,
        eventSourceName: String,
        resourceGroupName: String,
    ): GetIoTHubEventSourceResult {
        val argument = GetIoTHubEventSourcePlainArgs(
            environmentName = environmentName,
            eventSourceName = eventSourceName,
            resourceGroupName = resourceGroupName,
        )
        return getIoTHubEventSourceResultToKotlin(getIoTHubEventSourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getIoTHubEventSource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;timeseriesinsights&#46;kotlin&#46;inputs&#46;GetIoTHubEventSourcePlainArgs].
     * @return An event source that receives its data from an Azure IoTHub.
     */
    public suspend
    fun getIoTHubEventSource(argument: suspend GetIoTHubEventSourcePlainArgsBuilder.() -> Unit):
        GetIoTHubEventSourceResult {
        val builder = GetIoTHubEventSourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIoTHubEventSourceResultToKotlin(getIoTHubEventSourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the private endpoint connection of the environment in the given resource group.
     * Azure REST API version: 2021-03-31-preview.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param environmentName The name of the Time Series Insights environment associated with the specified resource group.
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName Name of an Azure Resource group.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        environmentName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            environmentName = environmentName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;timeseriesinsights&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the reference data set with the specified name in the specified environment.
     * Azure REST API version: 2020-05-15.
     * Other available API versions: 2017-11-15, 2021-06-30-preview.
     * @param argument null
     * @return A reference data set provides metadata about the events in an environment. Metadata in the reference data set will be joined with events as they are read from event sources. The metadata that makes up the reference data set is uploaded or modified through the Time Series Insights data plane APIs.
     */
    public suspend fun getReferenceDataSet(argument: GetReferenceDataSetPlainArgs):
        GetReferenceDataSetResult =
        getReferenceDataSetResultToKotlin(getReferenceDataSetPlain(argument.toJava()).await())

    /**
     * @see [getReferenceDataSet].
     * @param environmentName The name of the Time Series Insights environment associated with the specified resource group.
     * @param referenceDataSetName The name of the Time Series Insights reference data set associated with the specified environment.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return A reference data set provides metadata about the events in an environment. Metadata in the reference data set will be joined with events as they are read from event sources. The metadata that makes up the reference data set is uploaded or modified through the Time Series Insights data plane APIs.
     */
    public suspend fun getReferenceDataSet(
        environmentName: String,
        referenceDataSetName: String,
        resourceGroupName: String,
    ): GetReferenceDataSetResult {
        val argument = GetReferenceDataSetPlainArgs(
            environmentName = environmentName,
            referenceDataSetName = referenceDataSetName,
            resourceGroupName = resourceGroupName,
        )
        return getReferenceDataSetResultToKotlin(getReferenceDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getReferenceDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;timeseriesinsights&#46;kotlin&#46;inputs&#46;GetReferenceDataSetPlainArgs].
     * @return A reference data set provides metadata about the events in an environment. Metadata in the reference data set will be joined with events as they are read from event sources. The metadata that makes up the reference data set is uploaded or modified through the Time Series Insights data plane APIs.
     */
    public suspend
    fun getReferenceDataSet(argument: suspend GetReferenceDataSetPlainArgsBuilder.() -> Unit):
        GetReferenceDataSetResult {
        val builder = GetReferenceDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReferenceDataSetResultToKotlin(getReferenceDataSetPlain(builtArgument.toJava()).await())
    }
}
