@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress" is specified, new events will not be read from the event source. If "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The default behavior is PurgeOldData.
 */
public enum class StorageLimitExceededBehavior(
    public val javaValue:
    com.pulumi.azurenative.timeseriesinsights.enums.StorageLimitExceededBehavior,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.enums.StorageLimitExceededBehavior> {
    PurgeOldData(com.pulumi.azurenative.timeseriesinsights.enums.StorageLimitExceededBehavior.PurgeOldData),
    PauseIngress(com.pulumi.azurenative.timeseriesinsights.enums.StorageLimitExceededBehavior.PauseIngress),
    ;

    override fun toJava():
        com.pulumi.azurenative.timeseriesinsights.enums.StorageLimitExceededBehavior = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.enums.StorageLimitExceededBehavior):
            StorageLimitExceededBehavior =
            StorageLimitExceededBehavior.values().first { it.javaValue == javaType }
    }
}
