@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.inputs

import com.pulumi.azurenative.timeseriesinsights.inputs.GetReferenceDataSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName The name of the Time Series Insights environment associated with the specified resource group.
 * @property referenceDataSetName The name of the Time Series Insights reference data set associated with the specified environment.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetReferenceDataSetPlainArgs(
    public val environmentName: String,
    public val referenceDataSetName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.inputs.GetReferenceDataSetPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.timeseriesinsights.inputs.GetReferenceDataSetPlainArgs =
        com.pulumi.azurenative.timeseriesinsights.inputs.GetReferenceDataSetPlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .referenceDataSetName(referenceDataSetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReferenceDataSetPlainArgs].
 */
@PulumiTagMarker
public class GetReferenceDataSetPlainArgsBuilder internal constructor() {
    private var environmentName: String? = null

    private var referenceDataSetName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("kfjeipunmrbsalof")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value The name of the Time Series Insights reference data set associated with the specified environment.
     */
    @JvmName("hoiodpgmvaasfkyk")
    public suspend fun referenceDataSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.referenceDataSetName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("modthogmjcxnfwpw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetReferenceDataSetPlainArgs = GetReferenceDataSetPlainArgs(
        environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
        referenceDataSetName = referenceDataSetName ?: throw
            PulumiNullFieldException("referenceDataSetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
