@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.inputs

import com.pulumi.azurenative.timeseriesinsights.inputs.LocalTimestampTimeZoneOffsetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An object that represents the offset information for the local timestamp format specified. Should not be specified for LocalTimestampFormat - Embedded.
 * @property propertyName The event property that will be contain the offset information to calculate the local timestamp. When the LocalTimestampFormat is Iana, the property name will contain the name of the column which contains IANA Timezone Name (eg: Americas/Los Angeles). When LocalTimestampFormat is Timespan, it contains the name of property which contains values representing the offset (eg: P1D or 1.00:00:00)
 */
public data class LocalTimestampTimeZoneOffsetArgs(
    public val propertyName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.inputs.LocalTimestampTimeZoneOffsetArgs> {
    override fun toJava():
        com.pulumi.azurenative.timeseriesinsights.inputs.LocalTimestampTimeZoneOffsetArgs =
        com.pulumi.azurenative.timeseriesinsights.inputs.LocalTimestampTimeZoneOffsetArgs.builder()
            .propertyName(propertyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocalTimestampTimeZoneOffsetArgs].
 */
@PulumiTagMarker
public class LocalTimestampTimeZoneOffsetArgsBuilder internal constructor() {
    private var propertyName: Output<String>? = null

    /**
     * @param value The event property that will be contain the offset information to calculate the local timestamp. When the LocalTimestampFormat is Iana, the property name will contain the name of the column which contains IANA Timezone Name (eg: Americas/Los Angeles). When LocalTimestampFormat is Timespan, it contains the name of property which contains values representing the offset (eg: P1D or 1.00:00:00)
     */
    @JvmName("tblvgevggufnbhgv")
    public suspend fun propertyName(`value`: Output<String>) {
        this.propertyName = value
    }

    /**
     * @param value The event property that will be contain the offset information to calculate the local timestamp. When the LocalTimestampFormat is Iana, the property name will contain the name of the column which contains IANA Timezone Name (eg: Americas/Los Angeles). When LocalTimestampFormat is Timespan, it contains the name of property which contains values representing the offset (eg: P1D or 1.00:00:00)
     */
    @JvmName("ejatdqmafvqmmmiv")
    public suspend fun propertyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyName = mapped
    }

    internal fun build(): LocalTimestampTimeZoneOffsetArgs = LocalTimestampTimeZoneOffsetArgs(
        propertyName = propertyName,
    )
}
