@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The storage configuration provides the non-secret connection details about the customer storage account that is used to store the environment's data.
 * @property accountName The name of the storage account that will hold the environment's Gen2 data.
 */
public data class Gen2StorageConfigurationOutputResponse(
    public val accountName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.Gen2StorageConfigurationOutputResponse):
            Gen2StorageConfigurationOutputResponse = Gen2StorageConfigurationOutputResponse(
            accountName = javaType.accountName(),
        )
    }
}
