@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.ParameterDefinitionResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.PipelineJobErrorResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.ParameterDefinitionResponse.Companion.toKotlin as parameterDefinitionResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.PipelineJobErrorResponse.Companion.toKotlin as pipelineJobErrorResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PipelineJob].
 */
@PulumiTagMarker
public class PipelineJobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineJobArgs = PipelineJobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineJobArgsBuilder.() -> Unit) {
        val builder = PipelineJobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PipelineJob {
        val builtJavaResource =
            com.pulumi.azurenative.videoanalyzer.PipelineJob(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PipelineJob(builtJavaResource)
    }
}

/**
 * Pipeline job represents a unique instance of a batch topology, used for offline processing of selected portions of archived content.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-11-01-preview.
 * ## Example Usage
 * ### Create or update a pipeline job
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pipelineJob = new AzureNative.VideoAnalyzer.PipelineJob("pipelineJob", new()
 *     {
 *         AccountName = "testaccount2",
 *         Description = "Pipeline Job 1 Dsecription",
 *         Parameters = new[]
 *         {
 *             new AzureNative.VideoAnalyzer.Inputs.ParameterDefinitionArgs
 *             {
 *                 Name = "timesequences",
 *                 Value = "[[\"2020-10-05T03:30:00Z\", \"2020-10-05T04:30:00Z\"]]",
 *             },
 *             new AzureNative.VideoAnalyzer.Inputs.ParameterDefinitionArgs
 *             {
 *                 Name = "videoSourceName",
 *                 Value = "camera001",
 *             },
 *         },
 *         PipelineJobName = "pipelineJob1",
 *         ResourceGroupName = "testrg",
 *         TopologyName = "pipelinetopology1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/videoanalyzer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videoanalyzer.NewPipelineJob(ctx, "pipelineJob", &videoanalyzer.PipelineJobArgs{
 * 			AccountName: pulumi.String("testaccount2"),
 * 			Description: pulumi.String("Pipeline Job 1 Dsecription"),
 * 			Parameters: []videoanalyzer.ParameterDefinitionArgs{
 * 				{
 * 					Name:  pulumi.String("timesequences"),
 * 					Value: pulumi.String("[[\"2020-10-05T03:30:00Z\", \"2020-10-05T04:30:00Z\"]]"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("videoSourceName"),
 * 					Value: pulumi.String("camera001"),
 * 				},
 * 			},
 * 			PipelineJobName:   pulumi.String("pipelineJob1"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			TopologyName:      pulumi.String("pipelinetopology1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.videoanalyzer.PipelineJob;
 * import com.pulumi.azurenative.videoanalyzer.PipelineJobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pipelineJob = new PipelineJob("pipelineJob", PipelineJobArgs.builder()
 *             .accountName("testaccount2")
 *             .description("Pipeline Job 1 Dsecription")
 *             .parameters(
 *                 Map.ofEntries(
 *                     Map.entry("name", "timesequences"),
 *                     Map.entry("value", "[[\"2020-10-05T03:30:00Z\", \"2020-10-05T04:30:00Z\"]]")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "videoSourceName"),
 *                     Map.entry("value", "camera001")
 *                 ))
 *             .pipelineJobName("pipelineJob1")
 *             .resourceGroupName("testrg")
 *             .topologyName("pipelinetopology1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:PipelineJob pipelineJob1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/pipelineJobs/{pipelineJobName}
 * ```
 */
public class PipelineJob internal constructor(
    override val javaResource: com.pulumi.azurenative.videoanalyzer.PipelineJob,
) : KotlinCustomResource(javaResource, PipelineJobMapper) {
    /**
     * An optional description for the pipeline.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Details about the error, in case the pipeline job fails.
     */
    public val error: Output<PipelineJobErrorResponse>
        get() = javaResource.error().applyValue({ args0 ->
            args0.let({ args0 ->
                pipelineJobErrorResponseToKotlin(args0)
            })
        })

    /**
     * The date-time by when this pipeline job will be automatically deleted from your account.
     */
    public val expiration: Output<String>
        get() = javaResource.expiration().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of the instance level parameter values for the user-defined topology parameters. A pipeline can only define or override parameters values for parameters which have been declared in the referenced topology. Topology parameters without a default value must be defined. Topology parameters with a default value can be optionally be overridden.
     */
    public val parameters: Output<List<ParameterDefinitionResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> parameterDefinitionResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Current state of the pipeline (read-only).
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Reference to an existing pipeline topology. When activated, this pipeline job will process content according to the pipeline topology definition.
     */
    public val topologyName: Output<String>
        get() = javaResource.topologyName().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PipelineJobMapper : ResourceMapper<PipelineJob> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.videoanalyzer.PipelineJob::class == javaResource::class

    override fun map(javaResource: Resource): PipelineJob = PipelineJob(
        javaResource as
            com.pulumi.azurenative.videoanalyzer.PipelineJob,
    )
}

/**
 * @see [PipelineJob].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PipelineJob].
 */
public suspend fun pipelineJob(name: String, block: suspend PipelineJobResourceBuilder.() -> Unit):
    PipelineJob {
    val builder = PipelineJobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PipelineJob].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipelineJob(name: String): PipelineJob {
    val builder = PipelineJobResourceBuilder()
    builder.name(name)
    return builder.build()
}
