@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.EncoderProcessorResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.ParameterDeclarationResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.RtspSourceResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoSinkResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoSourceResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.EncoderProcessorResponse.Companion.toKotlin as encoderProcessorResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.ParameterDeclarationResponse.Companion.toKotlin as parameterDeclarationResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoSinkResponse.Companion.toKotlin as videoSinkResponseToKotlin

/**
 * Builder for [PipelineTopology].
 */
@PulumiTagMarker
public class PipelineTopologyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineTopologyArgs = PipelineTopologyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineTopologyArgsBuilder.() -> Unit) {
        val builder = PipelineTopologyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PipelineTopology {
        val builtJavaResource =
            com.pulumi.azurenative.videoanalyzer.PipelineTopology(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PipelineTopology(builtJavaResource)
    }
}

/**
 * Pipeline topology describes the processing steps to be applied when processing content for a particular outcome. The topology should be defined according to the scenario to be achieved and can be reused across many pipeline instances which share the same processing characteristics. For instance, a pipeline topology which captures content from a RTSP camera and archives the content can be reused across many different cameras, as long as the same processing is to be applied across all the cameras. Individual instance properties can be defined through the use of user-defined parameters, which allow for a topology to be parameterized. This allows  individual pipelines refer to different values, such as individual cameras' RTSP endpoints and credentials. Overall a topology is composed of the following:
 *   - Parameters: list of user defined parameters that can be references across the topology nodes.
 *   - Sources: list of one or more data sources nodes such as an RTSP source which allows for content to be ingested from cameras.
 *   - Processors: list of nodes which perform data analysis or transformations.
 *   - Sinks: list of one or more data sinks which allow for data to be stored or exported to other destinations.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-11-01-preview.
 * ## Example Usage
 * ### Create or update a pipeline topology with an Rtsp source and video sink.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pipelineTopology = new AzureNative.VideoAnalyzer.PipelineTopology("pipelineTopology", new()
 *     {
 *         AccountName = "testaccount2",
 *         Description = "Pipeline Topology 1 Description",
 *         Kind = "Live",
 *         Parameters = new[]
 *         {
 *             new AzureNative.VideoAnalyzer.Inputs.ParameterDeclarationArgs
 *             {
 *                 Default = "rtsp://microsoft.com/video.mp4",
 *                 Description = "rtsp source url parameter",
 *                 Name = "rtspUrlParameter",
 *                 Type = "String",
 *             },
 *             new AzureNative.VideoAnalyzer.Inputs.ParameterDeclarationArgs
 *             {
 *                 Default = "password",
 *                 Description = "rtsp source password parameter",
 *                 Name = "rtspPasswordParameter",
 *                 Type = "SecretString",
 *             },
 *         },
 *         PipelineTopologyName = "pipelineTopology1",
 *         ResourceGroupName = "testrg",
 *         Sinks = new[]
 *         {
 *             {
 *                 { "inputs", new[]
 *                 {
 *                     new AzureNative.VideoAnalyzer.Inputs.NodeInputArgs
 *                     {
 *                         NodeName = "rtspSource",
 *                     },
 *                 } },
 *                 { "name", "videoSink" },
 *                 { "type", "#Microsoft.VideoAnalyzer.VideoSink" },
 *                 { "videoCreationProperties", new AzureNative.VideoAnalyzer.Inputs.VideoCreationPropertiesArgs
 *                 {
 *                     Description = "Parking lot south entrance",
 *                     SegmentLength = "PT30S",
 *                     Title = "Parking Lot (Camera 1)",
 *                 } },
 *                 { "videoName", "camera001" },
 *                 { "videoPublishingOptions", new AzureNative.VideoAnalyzer.Inputs.VideoPublishingOptionsArgs
 *                 {
 *                     DisableArchive = "false",
 *                     DisableRtspPublishing = "true",
 *                 } },
 *             },
 *         },
 *         Sku = new AzureNative.VideoAnalyzer.Inputs.SkuArgs
 *         {
 *             Name = "Live_S1",
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.VideoAnalyzer.Inputs.RtspSourceArgs
 *             {
 *                 Endpoint = new AzureNative.VideoAnalyzer.Inputs.UnsecuredEndpointArgs
 *                 {
 *                     Credentials = new AzureNative.VideoAnalyzer.Inputs.UsernamePasswordCredentialsArgs
 *                     {
 *                         Password = "${rtspPasswordParameter}",
 *                         Type = "#Microsoft.VideoAnalyzer.UsernamePasswordCredentials",
 *                         Username = "username",
 *                     },
 *                     Type = "#Microsoft.VideoAnalyzer.UnsecuredEndpoint",
 *                     Url = "${rtspUrlParameter}",
 *                 },
 *                 Name = "rtspSource",
 *                 Transport = "Http",
 *                 Type = "#Microsoft.VideoAnalyzer.RtspSource",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/videoanalyzer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videoanalyzer.NewPipelineTopology(ctx, "pipelineTopology", &videoanalyzer.PipelineTopologyArgs{
 * 			AccountName: pulumi.String("testaccount2"),
 * 			Description: pulumi.String("Pipeline Topology 1 Description"),
 * 			Kind:        pulumi.String("Live"),
 * 			Parameters: []videoanalyzer.ParameterDeclarationArgs{
 * 				{
 * 					Default:     pulumi.String("rtsp://microsoft.com/video.mp4"),
 * 					Description: pulumi.String("rtsp source url parameter"),
 * 					Name:        pulumi.String("rtspUrlParameter"),
 * 					Type:        pulumi.String("String"),
 * 				},
 * 				{
 * 					Default:     pulumi.String("password"),
 * 					Description: pulumi.String("rtsp source password parameter"),
 * 					Name:        pulumi.String("rtspPasswordParameter"),
 * 					Type:        pulumi.String("SecretString"),
 * 				},
 * 			},
 * 			PipelineTopologyName: pulumi.String("pipelineTopology1"),
 * 			ResourceGroupName:    pulumi.String("testrg"),
 * 			Sinks: []videoanalyzer.VideoSinkArgs{
 * 				{
 * 					Inputs: videoanalyzer.NodeInputArray{
 * 						{
 * 							NodeName: pulumi.String("rtspSource"),
 * 						},
 * 					},
 * 					Name: pulumi.String("videoSink"),
 * 					Type: pulumi.String("#Microsoft.VideoAnalyzer.VideoSink"),
 * 					VideoCreationProperties: {
 * 						Description:   pulumi.String("Parking lot south entrance"),
 * 						SegmentLength: pulumi.String("PT30S"),
 * 						Title:         pulumi.String("Parking Lot (Camera 1)"),
 * 					},
 * 					VideoName: pulumi.String("camera001"),
 * 					VideoPublishingOptions: {
 * 						DisableArchive:        pulumi.String("false"),
 * 						DisableRtspPublishing: pulumi.String("true"),
 * 					},
 * 				},
 * 			},
 * 			Sku: &videoanalyzer.SkuArgs{
 * 				Name: pulumi.String("Live_S1"),
 * 			},
 * 			Sources: pulumi.Array{
 * 				videoanalyzer.RtspSource{
 * 					Endpoint: videoanalyzer.UnsecuredEndpoint{
 * 						Credentials: videoanalyzer.UsernamePasswordCredentials{
 * 							Password: "${rtspPasswordParameter}",
 * 							Type:     "#Microsoft.VideoAnalyzer.UsernamePasswordCredentials",
 * 							Username: "username",
 * 						},
 * 						Type: "#Microsoft.VideoAnalyzer.UnsecuredEndpoint",
 * 						Url:  "${rtspUrlParameter}",
 * 					},
 * 					Name:      "rtspSource",
 * 					Transport: "Http",
 * 					Type:      "#Microsoft.VideoAnalyzer.RtspSource",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.videoanalyzer.PipelineTopology;
 * import com.pulumi.azurenative.videoanalyzer.PipelineTopologyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pipelineTopology = new PipelineTopology("pipelineTopology", PipelineTopologyArgs.builder()
 *             .accountName("testaccount2")
 *             .description("Pipeline Topology 1 Description")
 *             .kind("Live")
 *             .parameters(
 *                 Map.ofEntries(
 *                     Map.entry("default", "rtsp://microsoft.com/video.mp4"),
 *                     Map.entry("description", "rtsp source url parameter"),
 *                     Map.entry("name", "rtspUrlParameter"),
 *                     Map.entry("type", "String")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("default", "password"),
 *                     Map.entry("description", "rtsp source password parameter"),
 *                     Map.entry("name", "rtspPasswordParameter"),
 *                     Map.entry("type", "SecretString")
 *                 ))
 *             .pipelineTopologyName("pipelineTopology1")
 *             .resourceGroupName("testrg")
 *             .sinks(Map.ofEntries(
 *                 Map.entry("inputs", Map.of("nodeName", "rtspSource")),
 *                 Map.entry("name", "videoSink"),
 *                 Map.entry("type", "#Microsoft.VideoAnalyzer.VideoSink"),
 *                 Map.entry("videoCreationProperties", Map.ofEntries(
 *                     Map.entry("description", "Parking lot south entrance"),
 *                     Map.entry("segmentLength", "PT30S"),
 *                     Map.entry("title", "Parking Lot (Camera 1)")
 *                 )),
 *                 Map.entry("videoName", "camera001"),
 *                 Map.entry("videoPublishingOptions", Map.ofEntries(
 *                     Map.entry("disableArchive", "false"),
 *                     Map.entry("disableRtspPublishing", "true")
 *                 ))
 *             ))
 *             .sku(Map.of("name", "Live_S1"))
 *             .sources(Map.ofEntries(
 *                 Map.entry("endpoint", Map.ofEntries(
 *                     Map.entry("credentials", Map.ofEntries(
 *                         Map.entry("password", "${rtspPasswordParameter}"),
 *                         Map.entry("type", "#Microsoft.VideoAnalyzer.UsernamePasswordCredentials"),
 *                         Map.entry("username", "username")
 *                     )),
 *                     Map.entry("type", "#Microsoft.VideoAnalyzer.UnsecuredEndpoint"),
 *                     Map.entry("url", "${rtspUrlParameter}")
 *                 )),
 *                 Map.entry("name", "rtspSource"),
 *                 Map.entry("transport", "Http"),
 *                 Map.entry("type", "#Microsoft.VideoAnalyzer.RtspSource")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:PipelineTopology pipelineTopology1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/pipelineTopologies/{pipelineTopologyName}
 * ```
 */
public class PipelineTopology internal constructor(
    override val javaResource: com.pulumi.azurenative.videoanalyzer.PipelineTopology,
) : KotlinCustomResource(javaResource, PipelineTopologyMapper) {
    /**
     * An optional description of the pipeline topology. It is recommended that the expected use of the topology to be described here.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Topology kind.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern. Parameters can have optional default values and can later be defined in individual instances of the pipeline.
     */
    public val parameters: Output<List<ParameterDeclarationResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> parameterDeclarationResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
     */
    public val processors: Output<List<EncoderProcessorResponse>>?
        get() = javaResource.processors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> encoderProcessorResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
     */
    public val sinks: Output<List<VideoSinkResponse>>
        get() = javaResource.sinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    videoSinkResponseToKotlin(args0)
                })
            })
        })

    /**
     * Describes the properties of a SKU.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * List of the topology source nodes. Source nodes enable external data to be ingested by the pipeline.
     */
    public val sources: Output<List<Either<RtspSourceResponse, VideoSourceResponse>>>
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.videoanalyzer.kotlin.outputs.RtspSourceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoSourceResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PipelineTopologyMapper : ResourceMapper<PipelineTopology> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.videoanalyzer.PipelineTopology::class == javaResource::class

    override fun map(javaResource: Resource): PipelineTopology = PipelineTopology(
        javaResource as
            com.pulumi.azurenative.videoanalyzer.PipelineTopology,
    )
}

/**
 * @see [PipelineTopology].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PipelineTopology].
 */
public suspend fun pipelineTopology(
    name: String,
    block: suspend PipelineTopologyResourceBuilder.() -> Unit,
): PipelineTopology {
    val builder = PipelineTopologyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PipelineTopology].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipelineTopology(name: String): PipelineTopology {
    val builder = PipelineTopologyResourceBuilder()
    builder.name(name)
    return builder.build()
}
