@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.PipelineTopologyArgs.builder
import com.pulumi.azurenative.videoanalyzer.kotlin.enums.Kind
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.EncoderProcessorArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.EncoderProcessorArgsBuilder
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.ParameterDeclarationArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.ParameterDeclarationArgsBuilder
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.RtspSourceArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.SkuArgsBuilder
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.VideoSinkArgs
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.VideoSinkArgsBuilder
import com.pulumi.azurenative.videoanalyzer.kotlin.inputs.VideoSourceArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Pipeline topology describes the processing steps to be applied when processing content for a particular outcome. The topology should be defined according to the scenario to be achieved and can be reused across many pipeline instances which share the same processing characteristics. For instance, a pipeline topology which captures content from a RTSP camera and archives the content can be reused across many different cameras, as long as the same processing is to be applied across all the cameras. Individual instance properties can be defined through the use of user-defined parameters, which allow for a topology to be parameterized. This allows  individual pipelines refer to different values, such as individual cameras' RTSP endpoints and credentials. Overall a topology is composed of the following:
 *   - Parameters: list of user defined parameters that can be references across the topology nodes.
 *   - Sources: list of one or more data sources nodes such as an RTSP source which allows for content to be ingested from cameras.
 *   - Processors: list of nodes which perform data analysis or transformations.
 *   - Sinks: list of one or more data sinks which allow for data to be stored or exported to other destinations.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-11-01-preview.
 * ## Example Usage
 * ### Create or update a pipeline topology with an Rtsp source and video sink.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pipelineTopology = new AzureNative.VideoAnalyzer.PipelineTopology("pipelineTopology", new()
 *     {
 *         AccountName = "testaccount2",
 *         Description = "Pipeline Topology 1 Description",
 *         Kind = "Live",
 *         Parameters = new[]
 *         {
 *             new AzureNative.VideoAnalyzer.Inputs.ParameterDeclarationArgs
 *             {
 *                 Default = "rtsp://microsoft.com/video.mp4",
 *                 Description = "rtsp source url parameter",
 *                 Name = "rtspUrlParameter",
 *                 Type = "String",
 *             },
 *             new AzureNative.VideoAnalyzer.Inputs.ParameterDeclarationArgs
 *             {
 *                 Default = "password",
 *                 Description = "rtsp source password parameter",
 *                 Name = "rtspPasswordParameter",
 *                 Type = "SecretString",
 *             },
 *         },
 *         PipelineTopologyName = "pipelineTopology1",
 *         ResourceGroupName = "testrg",
 *         Sinks = new[]
 *         {
 *             {
 *                 { "inputs", new[]
 *                 {
 *                     new AzureNative.VideoAnalyzer.Inputs.NodeInputArgs
 *                     {
 *                         NodeName = "rtspSource",
 *                     },
 *                 } },
 *                 { "name", "videoSink" },
 *                 { "type", "#Microsoft.VideoAnalyzer.VideoSink" },
 *                 { "videoCreationProperties", new AzureNative.VideoAnalyzer.Inputs.VideoCreationPropertiesArgs
 *                 {
 *                     Description = "Parking lot south entrance",
 *                     SegmentLength = "PT30S",
 *                     Title = "Parking Lot (Camera 1)",
 *                 } },
 *                 { "videoName", "camera001" },
 *                 { "videoPublishingOptions", new AzureNative.VideoAnalyzer.Inputs.VideoPublishingOptionsArgs
 *                 {
 *                     DisableArchive = "false",
 *                     DisableRtspPublishing = "true",
 *                 } },
 *             },
 *         },
 *         Sku = new AzureNative.VideoAnalyzer.Inputs.SkuArgs
 *         {
 *             Name = "Live_S1",
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.VideoAnalyzer.Inputs.RtspSourceArgs
 *             {
 *                 Endpoint = new AzureNative.VideoAnalyzer.Inputs.UnsecuredEndpointArgs
 *                 {
 *                     Credentials = new AzureNative.VideoAnalyzer.Inputs.UsernamePasswordCredentialsArgs
 *                     {
 *                         Password = "${rtspPasswordParameter}",
 *                         Type = "#Microsoft.VideoAnalyzer.UsernamePasswordCredentials",
 *                         Username = "username",
 *                     },
 *                     Type = "#Microsoft.VideoAnalyzer.UnsecuredEndpoint",
 *                     Url = "${rtspUrlParameter}",
 *                 },
 *                 Name = "rtspSource",
 *                 Transport = "Http",
 *                 Type = "#Microsoft.VideoAnalyzer.RtspSource",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/videoanalyzer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videoanalyzer.NewPipelineTopology(ctx, "pipelineTopology", &videoanalyzer.PipelineTopologyArgs{
 * 			AccountName: pulumi.String("testaccount2"),
 * 			Description: pulumi.String("Pipeline Topology 1 Description"),
 * 			Kind:        pulumi.String("Live"),
 * 			Parameters: []videoanalyzer.ParameterDeclarationArgs{
 * 				{
 * 					Default:     pulumi.String("rtsp://microsoft.com/video.mp4"),
 * 					Description: pulumi.String("rtsp source url parameter"),
 * 					Name:        pulumi.String("rtspUrlParameter"),
 * 					Type:        pulumi.String("String"),
 * 				},
 * 				{
 * 					Default:     pulumi.String("password"),
 * 					Description: pulumi.String("rtsp source password parameter"),
 * 					Name:        pulumi.String("rtspPasswordParameter"),
 * 					Type:        pulumi.String("SecretString"),
 * 				},
 * 			},
 * 			PipelineTopologyName: pulumi.String("pipelineTopology1"),
 * 			ResourceGroupName:    pulumi.String("testrg"),
 * 			Sinks: []videoanalyzer.VideoSinkArgs{
 * 				{
 * 					Inputs: videoanalyzer.NodeInputArray{
 * 						{
 * 							NodeName: pulumi.String("rtspSource"),
 * 						},
 * 					},
 * 					Name: pulumi.String("videoSink"),
 * 					Type: pulumi.String("#Microsoft.VideoAnalyzer.VideoSink"),
 * 					VideoCreationProperties: {
 * 						Description:   pulumi.String("Parking lot south entrance"),
 * 						SegmentLength: pulumi.String("PT30S"),
 * 						Title:         pulumi.String("Parking Lot (Camera 1)"),
 * 					},
 * 					VideoName: pulumi.String("camera001"),
 * 					VideoPublishingOptions: {
 * 						DisableArchive:        pulumi.String("false"),
 * 						DisableRtspPublishing: pulumi.String("true"),
 * 					},
 * 				},
 * 			},
 * 			Sku: &videoanalyzer.SkuArgs{
 * 				Name: pulumi.String("Live_S1"),
 * 			},
 * 			Sources: pulumi.Array{
 * 				videoanalyzer.RtspSource{
 * 					Endpoint: videoanalyzer.UnsecuredEndpoint{
 * 						Credentials: videoanalyzer.UsernamePasswordCredentials{
 * 							Password: "${rtspPasswordParameter}",
 * 							Type:     "#Microsoft.VideoAnalyzer.UsernamePasswordCredentials",
 * 							Username: "username",
 * 						},
 * 						Type: "#Microsoft.VideoAnalyzer.UnsecuredEndpoint",
 * 						Url:  "${rtspUrlParameter}",
 * 					},
 * 					Name:      "rtspSource",
 * 					Transport: "Http",
 * 					Type:      "#Microsoft.VideoAnalyzer.RtspSource",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.videoanalyzer.PipelineTopology;
 * import com.pulumi.azurenative.videoanalyzer.PipelineTopologyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pipelineTopology = new PipelineTopology("pipelineTopology", PipelineTopologyArgs.builder()
 *             .accountName("testaccount2")
 *             .description("Pipeline Topology 1 Description")
 *             .kind("Live")
 *             .parameters(
 *                 Map.ofEntries(
 *                     Map.entry("default", "rtsp://microsoft.com/video.mp4"),
 *                     Map.entry("description", "rtsp source url parameter"),
 *                     Map.entry("name", "rtspUrlParameter"),
 *                     Map.entry("type", "String")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("default", "password"),
 *                     Map.entry("description", "rtsp source password parameter"),
 *                     Map.entry("name", "rtspPasswordParameter"),
 *                     Map.entry("type", "SecretString")
 *                 ))
 *             .pipelineTopologyName("pipelineTopology1")
 *             .resourceGroupName("testrg")
 *             .sinks(Map.ofEntries(
 *                 Map.entry("inputs", Map.of("nodeName", "rtspSource")),
 *                 Map.entry("name", "videoSink"),
 *                 Map.entry("type", "#Microsoft.VideoAnalyzer.VideoSink"),
 *                 Map.entry("videoCreationProperties", Map.ofEntries(
 *                     Map.entry("description", "Parking lot south entrance"),
 *                     Map.entry("segmentLength", "PT30S"),
 *                     Map.entry("title", "Parking Lot (Camera 1)")
 *                 )),
 *                 Map.entry("videoName", "camera001"),
 *                 Map.entry("videoPublishingOptions", Map.ofEntries(
 *                     Map.entry("disableArchive", "false"),
 *                     Map.entry("disableRtspPublishing", "true")
 *                 ))
 *             ))
 *             .sku(Map.of("name", "Live_S1"))
 *             .sources(Map.ofEntries(
 *                 Map.entry("endpoint", Map.ofEntries(
 *                     Map.entry("credentials", Map.ofEntries(
 *                         Map.entry("password", "${rtspPasswordParameter}"),
 *                         Map.entry("type", "#Microsoft.VideoAnalyzer.UsernamePasswordCredentials"),
 *                         Map.entry("username", "username")
 *                     )),
 *                     Map.entry("type", "#Microsoft.VideoAnalyzer.UnsecuredEndpoint"),
 *                     Map.entry("url", "${rtspUrlParameter}")
 *                 )),
 *                 Map.entry("name", "rtspSource"),
 *                 Map.entry("transport", "Http"),
 *                 Map.entry("type", "#Microsoft.VideoAnalyzer.RtspSource")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:PipelineTopology pipelineTopology1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/pipelineTopologies/{pipelineTopologyName}
 * ```
 * @property accountName The Azure Video Analyzer account name.
 * @property description An optional description of the pipeline topology. It is recommended that the expected use of the topology to be described here.
 * @property kind Topology kind.
 * @property parameters List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern. Parameters can have optional default values and can later be defined in individual instances of the pipeline.
 * @property pipelineTopologyName Pipeline topology unique identifier.
 * @property processors List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sinks List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
 * @property sku Describes the properties of a SKU.
 * @property sources List of the topology source nodes. Source nodes enable external data to be ingested by the pipeline.
 */
public data class PipelineTopologyArgs(
    public val accountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val kind: Output<Either<String, Kind>>? = null,
    public val parameters: Output<List<ParameterDeclarationArgs>>? = null,
    public val pipelineTopologyName: Output<String>? = null,
    public val processors: Output<List<EncoderProcessorArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sinks: Output<List<VideoSinkArgs>>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val sources: Output<List<Either<RtspSourceArgs, VideoSourceArgs>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.PipelineTopologyArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.PipelineTopologyArgs =
        com.pulumi.azurenative.videoanalyzer.PipelineTopologyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .pipelineTopologyName(pipelineTopologyName?.applyValue({ args0 -> args0 }))
            .processors(
                processors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sinks(sinks?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipelineTopologyArgs].
 */
@PulumiTagMarker
public class PipelineTopologyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var description: Output<String>? = null

    private var kind: Output<Either<String, Kind>>? = null

    private var parameters: Output<List<ParameterDeclarationArgs>>? = null

    private var pipelineTopologyName: Output<String>? = null

    private var processors: Output<List<EncoderProcessorArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sinks: Output<List<VideoSinkArgs>>? = null

    private var sku: Output<SkuArgs>? = null

    private var sources: Output<List<Either<RtspSourceArgs, VideoSourceArgs>>>? = null

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("jcddrqiatbclryph")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value An optional description of the pipeline topology. It is recommended that the expected use of the topology to be described here.
     */
    @JvmName("svfxwajlagxogeyw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Topology kind.
     */
    @JvmName("aktuuoanmawjkftj")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern. Parameters can have optional default values and can later be defined in individual instances of the pipeline.
     */
    @JvmName("rhhgbkwbnpavwcnu")
    public suspend fun parameters(`value`: Output<List<ParameterDeclarationArgs>>) {
        this.parameters = value
    }

    @JvmName("psxjjsgdbcsglsks")
    public suspend fun parameters(vararg values: Output<ParameterDeclarationArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern. Parameters can have optional default values and can later be defined in individual instances of the pipeline.
     */
    @JvmName("sjyasmpfjjywytuv")
    public suspend fun parameters(values: List<Output<ParameterDeclarationArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Pipeline topology unique identifier.
     */
    @JvmName("inwoiwibjxakexlq")
    public suspend fun pipelineTopologyName(`value`: Output<String>) {
        this.pipelineTopologyName = value
    }

    /**
     * @param value List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
     */
    @JvmName("yygmptbrjkkgvkwa")
    public suspend fun processors(`value`: Output<List<EncoderProcessorArgs>>) {
        this.processors = value
    }

    @JvmName("utcetrdolotvvelm")
    public suspend fun processors(vararg values: Output<EncoderProcessorArgs>) {
        this.processors = Output.all(values.asList())
    }

    /**
     * @param values List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
     */
    @JvmName("jxjjveroekowfhyj")
    public suspend fun processors(values: List<Output<EncoderProcessorArgs>>) {
        this.processors = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wwokvpwvheftdocw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
     */
    @JvmName("othtbgxgskycxgph")
    public suspend fun sinks(`value`: Output<List<VideoSinkArgs>>) {
        this.sinks = value
    }

    @JvmName("giuyshihtgqcchxj")
    public suspend fun sinks(vararg values: Output<VideoSinkArgs>) {
        this.sinks = Output.all(values.asList())
    }

    /**
     * @param values List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
     */
    @JvmName("uuvijkdxiqmeafae")
    public suspend fun sinks(values: List<Output<VideoSinkArgs>>) {
        this.sinks = Output.all(values)
    }

    /**
     * @param value Describes the properties of a SKU.
     */
    @JvmName("fssxqcpduiykrwxc")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value List of the topology source nodes. Source nodes enable external data to be ingested by the pipeline.
     */
    @JvmName("ibhcqpwfiqsejiri")
    public suspend fun sources(`value`: Output<List<Either<RtspSourceArgs, VideoSourceArgs>>>) {
        this.sources = value
    }

    @JvmName("ayboxpsntdtcinfj")
    public suspend fun sources(vararg values: Output<Either<RtspSourceArgs, VideoSourceArgs>>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values List of the topology source nodes. Source nodes enable external data to be ingested by the pipeline.
     */
    @JvmName("imavvhkjqhxcflqf")
    public suspend fun sources(values: List<Output<Either<RtspSourceArgs, VideoSourceArgs>>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value The Azure Video Analyzer account name.
     */
    @JvmName("gbelicmpfniovsee")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value An optional description of the pipeline topology. It is recommended that the expected use of the topology to be described here.
     */
    @JvmName("yulxtmyiwewdrkbg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Topology kind.
     */
    @JvmName("braasbakfucfhksk")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Topology kind.
     */
    @JvmName("qcswgvtkwuxnlexs")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Topology kind.
     */
    @JvmName("cguyfyddgaxecebc")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern. Parameters can have optional default values and can later be defined in individual instances of the pipeline.
     */
    @JvmName("rsticynfcewerjih")
    public suspend fun parameters(`value`: List<ParameterDeclarationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern. Parameters can have optional default values and can later be defined in individual instances of the pipeline.
     */
    @JvmName("fjciypgiyunsnptm")
    public suspend
    fun parameters(argument: List<suspend ParameterDeclarationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterDeclarationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern. Parameters can have optional default values and can later be defined in individual instances of the pipeline.
     */
    @JvmName("elqsbkrfyyhuilde")
    public suspend fun parameters(
        vararg
        argument: suspend ParameterDeclarationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ParameterDeclarationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern. Parameters can have optional default values and can later be defined in individual instances of the pipeline.
     */
    @JvmName("udnftuucgsnkfula")
    public suspend fun parameters(argument: suspend ParameterDeclarationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ParameterDeclarationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values List of the topology parameter declarations. Parameters declared here can be referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern. Parameters can have optional default values and can later be defined in individual instances of the pipeline.
     */
    @JvmName("vhlooyttygftylga")
    public suspend fun parameters(vararg values: ParameterDeclarationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Pipeline topology unique identifier.
     */
    @JvmName("jvvkxldclhfkarpd")
    public suspend fun pipelineTopologyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineTopologyName = mapped
    }

    /**
     * @param value List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
     */
    @JvmName("cbdhdeyhtsyqrnmb")
    public suspend fun processors(`value`: List<EncoderProcessorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param argument List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
     */
    @JvmName("oyaftgcwpqucbbjc")
    public suspend fun processors(argument: List<suspend EncoderProcessorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EncoderProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
     */
    @JvmName("arjpoyxifamlsnhv")
    public suspend fun processors(vararg argument: suspend EncoderProcessorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EncoderProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
     */
    @JvmName("rwicvlnbakgwjqms")
    public suspend fun processors(argument: suspend EncoderProcessorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EncoderProcessorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param values List of the topology processor nodes. Processor nodes enable pipeline data to be analyzed, processed or transformed.
     */
    @JvmName("njlwbxvmruakbivh")
    public suspend fun processors(vararg values: EncoderProcessorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jmgjxhxovpnwoinh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
     */
    @JvmName("ipdawrxdqanjoxlt")
    public suspend fun sinks(`value`: List<VideoSinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param argument List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
     */
    @JvmName("xrjssacybcyybclb")
    public suspend fun sinks(argument: List<suspend VideoSinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VideoSinkArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
     */
    @JvmName("nujebqnuomraeeqd")
    public suspend fun sinks(vararg argument: suspend VideoSinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VideoSinkArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
     */
    @JvmName("iecurfwambdjwtkh")
    public suspend fun sinks(argument: suspend VideoSinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VideoSinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param values List of the topology sink nodes. Sink nodes allow pipeline data to be stored or exported.
     */
    @JvmName("benrcfmjopfejoax")
    public suspend fun sinks(vararg values: VideoSinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param value Describes the properties of a SKU.
     */
    @JvmName("lsmxadqkdeelcxns")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Describes the properties of a SKU.
     */
    @JvmName("eensfdqaagtflnwt")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value List of the topology source nodes. Source nodes enable external data to be ingested by the pipeline.
     */
    @JvmName("avcmcjajegxxehob")
    public suspend fun sources(`value`: List<Either<RtspSourceArgs, VideoSourceArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param values List of the topology source nodes. Source nodes enable external data to be ingested by the pipeline.
     */
    @JvmName("yujgppyjgbjoqqoa")
    public suspend fun sources(vararg values: Either<RtspSourceArgs, VideoSourceArgs>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    internal fun build(): PipelineTopologyArgs = PipelineTopologyArgs(
        accountName = accountName,
        description = description,
        kind = kind,
        parameters = parameters,
        pipelineTopologyName = pipelineTopologyName,
        processors = processors,
        resourceGroupName = resourceGroupName,
        sinks = sinks,
        sku = sku,
        sources = sources,
    )
}
