@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of key used to encrypt the Account Key.
 */
public enum class AccountEncryptionKeyType(
    public val javaValue: com.pulumi.azurenative.videoanalyzer.enums.AccountEncryptionKeyType,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.enums.AccountEncryptionKeyType> {
    /**
     * The Account Key is encrypted with a System Key.
     */
    SystemKey(com.pulumi.azurenative.videoanalyzer.enums.AccountEncryptionKeyType.SystemKey),

    /**
     * The Account Key is encrypted with a Customer Key.
     */
    CustomerKey(com.pulumi.azurenative.videoanalyzer.enums.AccountEncryptionKeyType.CustomerKey),
    ;

    override fun toJava(): com.pulumi.azurenative.videoanalyzer.enums.AccountEncryptionKeyType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.videoanalyzer.enums.AccountEncryptionKeyType):
            AccountEncryptionKeyType =
            AccountEncryptionKeyType.values().first { it.javaValue == javaType }
    }
}
