@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin.inputs

import com.pulumi.azurenative.videoanalyzer.inputs.AudioEncoderAacArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A custom preset for encoding audio with the AAC codec.
 * @property bitrateKbps Bitrate, in kilobits per second or Kbps, at which audio should be encoded (2-channel stereo audio at a sampling rate of 48 kHz). Allowed values are 96, 112, 128, 160, 192, 224, and 256. If omitted, the bitrate of the input audio is used.
 * @property type The discriminator for derived types.
 * Expected value is '#Microsoft.VideoAnalyzer.AudioEncoderAac'.
 */
public data class AudioEncoderAacArgs(
    public val bitrateKbps: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.videoanalyzer.inputs.AudioEncoderAacArgs> {
    override fun toJava(): com.pulumi.azurenative.videoanalyzer.inputs.AudioEncoderAacArgs =
        com.pulumi.azurenative.videoanalyzer.inputs.AudioEncoderAacArgs.builder()
            .bitrateKbps(bitrateKbps?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AudioEncoderAacArgs].
 */
@PulumiTagMarker
public class AudioEncoderAacArgsBuilder internal constructor() {
    private var bitrateKbps: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Bitrate, in kilobits per second or Kbps, at which audio should be encoded (2-channel stereo audio at a sampling rate of 48 kHz). Allowed values are 96, 112, 128, 160, 192, 224, and 256. If omitted, the bitrate of the input audio is used.
     */
    @JvmName("dwbbqdfalhwmocdx")
    public suspend fun bitrateKbps(`value`: Output<String>) {
        this.bitrateKbps = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.AudioEncoderAac'.
     */
    @JvmName("insetonufitomsli")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Bitrate, in kilobits per second or Kbps, at which audio should be encoded (2-channel stereo audio at a sampling rate of 48 kHz). Allowed values are 96, 112, 128, 160, 192, 224, and 256. If omitted, the bitrate of the input audio is used.
     */
    @JvmName("odibnnmbkcfqlktt")
    public suspend fun bitrateKbps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrateKbps = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.VideoAnalyzer.AudioEncoderAac'.
     */
    @JvmName("vxmdvsigxymyfxch")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AudioEncoderAacArgs = AudioEncoderAacArgs(
        bitrateKbps = bitrateKbps,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
